/*
 * Copyright (c) 2008, AIST.
 * All rights reserved. This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * National Institute of Advanced Industrial Science and Technology (AIST)
 */
/* This is a template file generated by command */
/* rtorb-idl --skeleton-impl echo.idl */
/* User must edit this file, inserting servant  */
/* specific code between markers. */

#if __cplusplus
#include "echo.hh"
#endif
#include "echo.h"

/*** App-specific servant structures ***/

typedef struct
{
   POA_Echo servant;
   PortableServer_POA poa;

   /* ------ add private attributes here ------ */
#if __cplusplus
   CORBA::Object_var obj; 
#endif
   /* ------ ---------- end ------------ ------ */
} impl_POA_Echo;

/*** Implementation stub prototypes ***/

static void impl_Echo__destroy(impl_POA_Echo * servant,
			       CORBA_Environment * ev);
static CORBA_string
impl_Echo_echoString(impl_POA_Echo * servant,
		     const CORBA_char * mesg, CORBA_Environment * ev);

static CORBA_string
impl_Echo_echoString2(impl_POA_Echo * servant,
		      const CORBA_char * mesg,
		      CORBA_string * res, CORBA_Environment * ev);

static CORBA_string
impl_Echo_echoString3(impl_POA_Echo * servant,
		      CORBA_string * mesg, CORBA_Environment * ev);

static CORBA_long
impl_Echo_plus(impl_POA_Echo * servant,
	       const CORBA_long x,
	       const CORBA_long y, CORBA_Environment * ev);

static void
impl_Echo_plus2(impl_POA_Echo * servant,
		const CORBA_long x,
		const CORBA_long y, CORBA_long * ans, CORBA_Environment * ev);

static CORBA_float
impl_Echo_divide(impl_POA_Echo * servant,
		 const CORBA_float x,
		 const CORBA_float y, CORBA_Environment * ev);

static void
impl_Echo_divide2(impl_POA_Echo * servant,
		  const CORBA_float x,
		  const CORBA_float y,
		  CORBA_float * ans, CORBA_Environment * ev);

/*** epv structures ***/

static PortableServer_ServantBase__epv impl_Echo_base_epv = {
   NULL,			/* _private data */
   (void (*)(void*, CORBA_Environment*))&impl_Echo__destroy,	/* finalize routine */
   NULL,			/* default_POA routine */
};

static POA_Echo__epv impl_Echo_epv = {
   NULL,			/* _private */
   (char*(*)(void*, const CORBA_char*, CORBA_Environment*)) &impl_Echo_echoString,

   (char*(*)(void*, const CORBA_char*, char**, CORBA_Environment*)) &impl_Echo_echoString2,

   (char*(*)(void*, char**, CORBA_Environment*)) &impl_Echo_echoString3,

   (CORBA_long (*)(void*, long int, long int, CORBA_Environment*)) &impl_Echo_plus,

   (void (*)(void*, long int, long int, CORBA_long*, CORBA_Environment*)) &impl_Echo_plus2,

   (CORBA_float (*)(void*, float, float, CORBA_Environment*)) &impl_Echo_divide,

   (void (*)(void*, float, float, CORBA_float*, CORBA_Environment*)) &impl_Echo_divide2,

};

/*** vepv structures ***/

static POA_Echo__vepv impl_Echo_vepv = {
   &impl_Echo_base_epv,
   &impl_Echo_epv,
};

/*** Stub implementations ***/

Echo
impl_Echo__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   Echo retval;
   impl_POA_Echo *newservant;
   PortableServer_ObjectId objid;

   newservant = (impl_POA_Echo *) calloc(sizeof(impl_POA_Echo), 1);
   newservant->servant.vepv = &impl_Echo_vepv;
   newservant->poa = poa;
   POA_Echo__init((PortableServer_Servant) newservant, ev);
   /* Before servant is going to be activated all
    * private attributes must be initialized.  */

   /* ------ init private attributes here ------ */
   /* ------ ---------- end ------------- ------ */

   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

static void
impl_Echo__destroy(impl_POA_Echo * servant, CORBA_Environment * ev)
{
   CORBA_Object_release((CORBA_Object) servant->poa, ev);

   /* No further remote method calls are delegated to 
    * servant and you may free your private attributes. */
   /* ------ free private attributes here ------ */
   /* ------ ---------- end ------------- ------ */

   POA_Echo__fini((PortableServer_Servant) servant, ev);

   free(servant);
}

static CORBA_string
impl_Echo_echoString(impl_POA_Echo * servant,
		     const CORBA_char * mesg, CORBA_Environment * ev)
{
   CORBA_string retval;

   /* ------   insert method code here   ------ */
#if __cplusplus
   Echo_i *obj = (Echo_i *)servant->obj;
   retval = obj->echoString((char *)mesg); 
#else
   retval = strdup(mesg);
#endif
   /* ------ ---------- end ------------ ------ */

   return retval;
}

static CORBA_string
impl_Echo_echoString2(impl_POA_Echo * servant,
		      const CORBA_char * mesg,
		      CORBA_string * res, CORBA_Environment * ev)
{
   CORBA_string retval;

   /* ------   insert method code here   ------ */
   /* ------ ---------- end ------------ ------ */

   return retval;
}

static CORBA_string
impl_Echo_echoString3(impl_POA_Echo * servant,
		      CORBA_string * mesg, CORBA_Environment * ev)
{
   CORBA_string retval;

   /* ------   insert method code here   ------ */
   /* ------ ---------- end ------------ ------ */

   return retval;
}

static CORBA_long
impl_Echo_plus(impl_POA_Echo * servant,
	       const CORBA_long x, const CORBA_long y, CORBA_Environment * ev)
{
   CORBA_long retval;

   /* ------   insert method code here   ------ */
   /* ------ ---------- end ------------ ------ */

   return retval;
}

static void
impl_Echo_plus2(impl_POA_Echo * servant,
		const CORBA_long x,
		const CORBA_long y, CORBA_long * ans, CORBA_Environment * ev)
{
   /* ------   insert method code here   ------ */
   /* ------ ---------- end ------------ ------ */
}

static CORBA_float
impl_Echo_divide(impl_POA_Echo * servant,
		 const CORBA_float x,
		 const CORBA_float y, CORBA_Environment * ev)
{
   CORBA_float retval;

   /* ------   insert method code here   ------ */
   /* ------ ---------- end ------------ ------ */

   return retval;
}

static void
impl_Echo_divide2(impl_POA_Echo * servant,
		  const CORBA_float x,
		  const CORBA_float y,
		  CORBA_float * ans, CORBA_Environment * ev)
{
   /* ------   insert method code here   ------ */
   /* ------ ---------- end ------------ ------ */
}
