/*
 * Copyright (c) 2008, AIST.
 * All rights reserved. This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * National Institute of Advanced Industrial Science and Technology (AIST)
 */
/* This is a template file generated by command */
/* rtorb-idl --skeleton-impl echo.idl */
/* User must edit this file, inserting servant  */
/* specific code between markers. */

#include "echo.h"

/*** App-specific servant structures ***/

typedef struct
{
   POA_RTC_Echo servant;
   PortableServer_POA poa;

   /* ------ add private attributes here ------ */
#if __cplusplus
    CORBA::Object_var impl_obj;
#endif				//__cplusplus
   /* ------ ---------- end ------------ ------ */
} impl_POA_RTC_Echo;

/*** Implementation stub prototypes ***/

static void impl_RTC_Echo__destroy(impl_POA_RTC_Echo * servant,
				   CORBA_Environment * ev);
static CORBA_string
impl_RTC_Echo_echoString(impl_POA_RTC_Echo * servant,
			 const CORBA_char * mesg, CORBA_Environment * ev);

static RTC_TimedLongSeq *impl_RTC_Echo_echoTimedLongSeq(impl_POA_RTC_Echo *
							servant,
							const RTC_TimedLongSeq
							* x,
							CORBA_Environment *
							ev);

static RTC_TimedStringSeq *impl_RTC_Echo_echoTimedStringSeq(impl_POA_RTC_Echo
							    * servant,
							    const
							    RTC_TimedStringSeq
							    * x,
							    CORBA_Environment
							    * ev);

/*** epv structures ***/

static PortableServer_ServantBase__epv impl_RTC_Echo_base_epv = {
   NULL,			/* _private data */
   (void (*)(void *, CORBA_Environment *)) &impl_RTC_Echo__destroy,	/* finalize routine */
   NULL,			/* default_POA routine */
};
static POA_RTC_Echo__epv impl_RTC_Echo_epv = {
   NULL,			/* _private */
   (CORBA_string(*)(void *, const CORBA_char *, CORBA_Environment *)) &
      impl_RTC_Echo_echoString,

   (RTC_TimedLongSeq *
    (*)(void *, const RTC_TimedLongSeq *,
	CORBA_Environment *)) & impl_RTC_Echo_echoTimedLongSeq,

   (RTC_TimedStringSeq *
    (*)(void *, const RTC_TimedStringSeq *,
	CORBA_Environment *)) & impl_RTC_Echo_echoTimedStringSeq,

};

/*** vepv structures ***/

static POA_RTC_Echo__vepv impl_RTC_Echo_vepv = {
   &impl_RTC_Echo_base_epv,
   &impl_RTC_Echo_epv,
};

/*** Stub implementations ***/

RTC_Echo
impl_RTC_Echo__create(PortableServer_POA poa, CORBA_Environment * ev)
{
   RTC_Echo retval;
   impl_POA_RTC_Echo *newservant;
   PortableServer_ObjectId objid;

   newservant = (impl_POA_RTC_Echo *) calloc(sizeof(impl_POA_RTC_Echo), 1);
   newservant->servant.vepv = &impl_RTC_Echo_vepv;
   newservant->poa = poa;
   POA_RTC_Echo__init((PortableServer_Servant) newservant, ev);
   /* Before servant is going to be activated all
    * private attributes must be initialized.  */

   /* ------ init private attributes here ------ */
   /* ------ ---------- end ------------- ------ */

   objid = PortableServer_POA_activate_object(poa, newservant, ev);
   free(objid);
   retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

   return retval;
}

static void
impl_RTC_Echo__destroy(impl_POA_RTC_Echo * servant, CORBA_Environment * ev)
{
   CORBA_Object_release((CORBA_Object) servant->poa, ev);

   /* No further remote method calls are delegated to 
    * servant and you may free your private attributes. */
   /* ------ free private attributes here ------ */
   /* ------ ---------- end ------------- ------ */

   POA_RTC_Echo__fini((PortableServer_Servant) servant, ev);

   free(servant);
}

static CORBA_string
impl_RTC_Echo_echoString(impl_POA_RTC_Echo * servant,
			 const CORBA_char * mesg, CORBA_Environment * ev)
{
   CORBA_string retval;

#if __cplusplus
   CORBA_Object object =
      impl_POA_ServantBase_to_Object((impl_POA_ServantBase *) servant);
   RTC::Echo_impl * obj = (RTC::Echo_impl *) object->impl_obj;
   retval = obj->echoString(mesg);
#else // C
   /* ------   insert method code here   ------ */
   retval = strdup(mesg);
   /* ------ ---------- end ------------ ------ */
#endif //__cplusplus

   return retval;
}

static RTC_TimedLongSeq *
impl_RTC_Echo_echoTimedLongSeq(impl_POA_RTC_Echo * servant,
			       const RTC_TimedLongSeq * x,
			       CORBA_Environment * ev)
{
   RTC_TimedLongSeq *retval;

#if __cplusplus
   CORBA_Object object =
      impl_POA_ServantBase_to_Object((impl_POA_ServantBase *) servant);
   RTC::Echo_impl * obj = (RTC::Echo_impl *) object->impl_obj;
   retval = obj->echoTimedLongSeq(x);
#else // C
   /* ------   insert method code here   ------ */
   int i;
   retval = RTC_TimedLongSeq__alloc();
   retval->data._length = retval->data._maximum = x->data._length;
   retval->data._buffer = CORBA_sequence_CORBA_long_allocbuf(x->data._length);

   for(i=0;i<x->data._length;i++){
          retval->data._buffer[i] = x->data._buffer[i] * 2;
   }

   /* ------ ---------- end ------------ ------ */
#endif //__cplusplus

   return retval;
}

static RTC_TimedStringSeq *
impl_RTC_Echo_echoTimedStringSeq(impl_POA_RTC_Echo * servant,
				 const RTC_TimedStringSeq * x,
				 CORBA_Environment * ev)
{
   RTC_TimedStringSeq *retval;

#if __cplusplus
   CORBA_Object object =
      impl_POA_ServantBase_to_Object((impl_POA_ServantBase *) servant);
   RTC::Echo_impl * obj = (RTC::Echo_impl *) object->impl_obj;
   retval = obj->echoTimedStringSeq(x);
#else // C
   /* ------   insert method code here   ------ */
   int i;
   retval = RTC_TimedStringSeq__alloc();
   retval->data._length = retval->data._maximum = x->data._length;
   retval->data._buffer = CORBA_sequence_CORBA_string_allocbuf(x->data._length);
   for(i=0;i<x->data._length;i++){
      retval->data._buffer[i] = RtORB_strdup(x->data._buffer[i], "");
   }
   /* ------ ---------- end ------------ ------ */
#endif //__cplusplus

   return retval;
}

/*** C++ interface ***/

#if __cplusplus
RTC::Echo_impl::Echo_impl(PortableServer::POA_ptr poa)
{
   _impl = impl_RTC_Echo__create(poa->_impl, &ev);
   _impl->impl_obj = this;
}
#endif	/* __cplusplus */
