/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.html;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;

/**
 * htmlɊ܂܂Ă邷ׂĂform̃Xg
 *
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class HtmlFormList implements Serializable {

	/**
	 * VAo[Whc
	 * 
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * form̃Xg
	 * 
	 * @since 1.00
	 */
	private ArrayList<HtmlForm> m_htmlFormList;
	
	/**
	 * HtmlFormList𐶐܂B
	 * 
	 * @since 1.00
	 */
	public HtmlFormList() {
		m_htmlFormList = new ArrayList<HtmlForm>();
	}
	
	/**
	 * formXgɒǉ܂B
	 * 
	 * @since 1.00
	 * @param p_htmlForm ǉform
	 */
	public void add(HtmlForm p_htmlForm) {
		m_htmlFormList.add(p_htmlForm);
	}
	
	/**
	 * w肳ꂽnameɃ}b`formԂ܂B
	 * 
	 * @since 1.00
	 * @param p_name name
	 * @return form
	 * @throws HtmlFormException w肳ꂽnameɃ}b`formȂꍇ
	 */
	public HtmlForm getHtmlFormByName(String p_name) throws HtmlFormException {
		if (m_htmlFormList.size()<=0) {
			throw new HtmlFormException("method:HtmlForm.getHtmlFormByName size=0");
		}
		for (int i=0;i<m_htmlFormList.size();i++) {
			HtmlForm htmlForm = m_htmlFormList.get(i);
			if (htmlForm.getName().equals(p_name)) {
				return htmlForm;
			}
		}
		throw new HtmlFormException("method:HtmlForm.getHtmlFormByName p_name=" + p_name);
	}

	
	/**
	 * w肳ꂽactionɃ}b`formԂ܂B
	 * 
	 * @since 1.00
	 * @param p_action action
	 * @return form
	 * @throws HtmlFormException w肳ꂽactionɃ}b`formȂꍇ
	 */
	public HtmlForm getHtmlFormByAction(String p_action) throws HtmlFormException {
		if (m_htmlFormList.size()<=0) {
			throw new HtmlFormException("method:HtmlForm.getHtmlFormByAction size=0");
		}
		for (int i=0;i<m_htmlFormList.size();i++) {
			HtmlForm htmlForm = m_htmlFormList.get(i);
			if (htmlForm.getAction().equals(p_action)) {
				return htmlForm;
			}
		}
		throw new HtmlFormException("method:HtmlForm.getHtmlFormByAction p_action=" + p_action);
	}
	
	/**
	 * w肳ꂽʒuformԂ܂B
	 * 
	 * @since 1.00
	 * @param p_index form̈ʒu
	 * @return form
	 * @throws HtmlFormException w肳ꂽʒuformȂꍇ
	 */
	public HtmlForm getHtmlFormByIndex(int p_index) throws HtmlFormException {
		if (m_htmlFormList.size()<=p_index) {
			throw new HtmlFormException("method:HtmlForm.getHtmlFormByIndex p_index=" + p_index);
		}
		return m_htmlFormList.get(p_index);
	}
	
	/**
	 * ׂĂform̓ew肵o̓Xg[ɏo͂܂B
	 * 
	 * @since 1.00
	 * @param p_out o̓Xg[
	 */
	public void print(PrintStream p_out) {
		for (int i=0; i<m_htmlFormList.size(); i++) {
			p_out.println("-- HtmlFormList(" + i + ") --");
			HtmlForm htmlForm = m_htmlFormList.get(i);
			htmlForm.print(p_out);
		}
	}
	
	/**
	 * form̌Ԃ܂B
	 * 
	 * @since 1.00
	 * @return form̌
	 */
	public int size() {
		return m_htmlFormList.size();
	}
	
}
