/**
 * Copyright (C) 2012 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.graph;

import java.awt.Color;

import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexObject;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.NmViewType;
import jp.robotbrain.signal.Tag;

/**
 * Ot̃C
 * 
 * @since 2.60
 * @author Copyright (C) 2012 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class GraphLayer {

	/**
	 * C
	 * 
	 * @since 2.60
	 */
	private final String m_name;

	/**
	 * ڐ
	 * 
	 * @since 2.60
	 */
	private final GraphRuler m_ruler;

	/**
	 * I[o[bvԍB
	 * ̃eNjJwWd˂ĕ\ꍇɓlZbgB
	 * XgœI[o[bvԍꍇɏdˍ킹ĕ`悳B
	 * 
	 * @since 2.60
	 */
	private final int m_overLapNo;

	/**
	 * ^Cgo[ɕ\镶
	 * 
	 * @since 2.60
	 */
	private String m_title;
	
	/**
	 * _ȉ̌
	 * 
	 * @since 2.60
	 */
	private int m_indexScale;

	/**
	 * Ot\eNjJwW
	 * 
	 * @since 2.60
	 */
	private IndexObjectList<?> m_srcList;

	/**
	 * Ot\eNjJwW̍ől
	 * 
	 * @since 2.60
	 */
	private double m_max;

	/**
	 * Ot\eNjJwW̍ŏl
	 * 
	 * @since 2.60
	 */
	private double m_min;

	/**
	 * plɂ郌C̍䗦(1`100)
	 * 
	 * @since 2.60
	 */
	private int m_heightRatio;

	/**
	 * Oɕ`悵wW̃^OieNjJwW`悷鎞Ɏgj
	 * 
	 * @since 2.60
	 */
	private Tag m_prevTag;

	/**
	 * eNjJwW`悷FB[\N̏ꍇ͘gqQ̐̕FB
	 * 
	 * @since 2.60
	 */
	private Color m_foreColor;

	/**
	 * ڍ׏̐FƓFŕ`悷邩B
	 * |WV̎ށiAjŐFꍇɎgpB
	 * 
	 * @since 2.60
	 */
	private boolean m_statusColor;

	/* yeTCY̐z
	---------------------------------------------------------------------  GraphPanel̏[
	                                                                                         
	                              m_top                getTitleBarTop()  getIndexTop()
	-------------------------------  C̏[                       
	                              } m_titleBarTopOffset                   
	-------------------------                                          
	25ړ              m_titleBarHeight                        
	-------------------------                                         
	                              } m_indexTopOffset                         
	       ....         .....
	      .    .    ....
	     .      ....
	    .
	-------------------------------
	*/

	/**
	 * C̏[YW
	 * 
	 * @since 2.60
	 */
	private int m_top;

	/**
	 * C̏[^Cgo[[܂ł̋
	 * 
	 * @since 2.60
	 */
	private int m_titleBarTopOffset;

	/**
	 * ^Cgo[̍
	 * 
	 * @since 2.60
	 */
	private int m_titleBarHeight;

	/**
	 * ^Cgo[̉[eNjJwW`GA[܂ł̗]
	 * 
	 * @since 2.60
	 */
	private int m_indexTopOffset;

	/**
	 * I[o[bvŖڐ̓Ƃꍇtrue
	 * 
	 * @since 2.60
	 */
	private boolean m_syncRuler;
	
	/**
	 * GraphLayer𐶐܂B
	 * 
	 * @since 2.60
	 * @param p_parent GraphPanel̃CX^X
	 * @param p_name C
	 * @param p_isMain CC̏ꍇtrue
	 * @param p_srcLine `悷eNjJwW
	 * @param p_overLapNo I[o[bvԍ 
	 * @throws GraphException CŃG[ꍇ
	 */
	protected GraphLayer(GraphPanel p_parent, String p_name, boolean p_isMain,
			IndexObjectList<?> p_srcLine, int p_overLapNo) throws GraphException {
		m_name = p_name;
		m_heightRatio = 100;
		m_overLapNo = p_overLapNo;
		m_titleBarTopOffset = 5;
		m_foreColor = Color.BLACK;
		m_title = "";
		m_syncRuler = true;
		m_ruler = new GraphRuler();
		// Qȏ̓_ȂƐЂȂ
		if (p_srcLine.size()<2) {
			throw new GraphException("Few SrcLine Values");
		}
		// C̏
		if (p_isMain) {
			initMainLayer(p_parent, p_srcLine);
		} else {
			initSubLayer(p_parent, p_srcLine);
		}
	}
	
	/**
	 * CC̏Bpl̉`łwWZoB
	 * 
	 * @since 2.60
	 * @param p_parent GraphPanel̃CX^X
	 * @param p_srcLine `悷eNjJwW
	 */
	private void initMainLayer(GraphPanel p_parent, IndexObjectList<?> p_srcLine) {
		// ʂɕ\\ȃeNjJwWZo
		int viewPointCount = p_parent.getWidthPointCount();
		if (viewPointCount > p_srcLine.size()) {
			viewPointCount = p_srcLine.size();
		}
		// őlAŏlA\[XCZbg
		if (p_srcLine instanceof CandleStickList) {
			CandleStickList src = (CandleStickList)p_srcLine;
			CandleStickList srcTail = src.getTailList(viewPointCount);
			if (p_srcLine.getViewType()==NmViewType.INDEXLINE_PERCENTAGE) {
				m_max = 100;
				m_min = 0;
			} else {
				m_max = srcTail.getMax();
				m_min = srcTail.getMin();
			}
			m_srcList = srcTail;
		} else if (p_srcLine instanceof IndexLine) {
			IndexLine src = (IndexLine)p_srcLine;
    		IndexLine srcTail = src.getTailLine(viewPointCount);
			if (p_srcLine.getViewType()==NmViewType.INDEXLINE_PERCENTAGE) {
				m_max = 100;
				m_min = 0;
			} else {
				m_max = srcTail.getMax().getValue();
				m_min = srcTail.getMin().getValue();
			}
			m_srcList = srcTail;
		} else {
			m_max = 0D;
			m_min = 0D;
    		m_srcList = p_srcLine;
		}
	}

	/**
	 * TuC̏BCC̃eNjJwWƓԂ`ΏۂƂB
	 * 
	 * @since 2.60
	 * @param p_parent GraphPanel̃CX^X
	 * @param p_srcLine `悷eNjJwW
	 */
	private void initSubLayer(GraphPanel p_parent, IndexObjectList<?> p_srcLine) throws GraphException {
		// CC`͈͂̊Jn^O擾
		if (p_parent.getMainLayer()==null) throw new GraphException("Not Found MainLayer");
		if (p_parent.getMainLayer().getSrcList().size()<=0) throw new GraphException("Not Found MainLayer");
		IndexObject idx = p_parent.getMainLayer().getSrcList().get(0);
		// őlAŏlA\[XCZbg
		if (p_srcLine instanceof CandleStickList) {
			CandleStickList src = (CandleStickList)p_srcLine;
			CandleStickList srcTail = src.getTailList(idx.getTag());
			if (p_srcLine.getViewType()==NmViewType.INDEXLINE_PERCENTAGE) {
				m_max = 100;
				m_min = 0;
			} else {
				m_max = srcTail.getMax();
				m_min = srcTail.getMin();
			}
			m_srcList = srcTail;
		} else if (p_srcLine instanceof IndexLine) {
			IndexLine src = (IndexLine)p_srcLine;
    		IndexLine srcTail = src.getTailLine(idx.getTag());
			if (p_srcLine.getViewType()==NmViewType.INDEXLINE_PERCENTAGE) {
				m_max = 100;
				m_min = 0;
			} else {
				m_max = srcTail.getMax().getValue();
				m_min = srcTail.getMin().getValue();
			}
			m_srcList = srcTail;
		} else {
			m_max = 0D;
			m_min = 0D;
    		m_srcList = p_srcLine;
		}
	}
	
	/**
	 * nbVR[hԂ܂B
	 * 
	 * @since 2.60
	 * @return nbVR[h
	 */
	@Override
	public int hashCode() {
		return m_name.hashCode();
	}

	/**
	 * w肵CƓꍇtrueԂ܂B
	 * ꂩǂ̓CŔ肵܂B
	 * 
	 * @since 2.60
	 * @param p_other Ώۂ̃C
	 */
	@Override
	public boolean equals(Object p_other) {
		if (!(p_other instanceof GraphLayer)) return false;
		GraphLayer other = (GraphLayer)p_other;
		if (this.m_name.equals(other.getName())) {
			return true;
		}
		return false;
	}

	/**
	 * CԂ܂B
	 * 
	 * @since 2.60
	 * @return C
	 */
	public String getName() {
		return m_name;
	}

	/**
	 * Ot\eNjJwW̍őlԂ܂B
	 * 
	 * @since 2.60
	 * @return Ot\eNjJwW̍ől
	 */
	protected double getMax() {
		return m_max;
	}

	/**
	 * Ot\eNjJwW̍őlݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_max Ot\eNjJwW̍ől
	 */
	protected void setMax(double p_max) {
		m_max = p_max;
	}

	/**
	 * Ot\eNjJwW̍ŏlԂ܂B
	 * 
	 * @since 2.60
	 * @return Ot\eNjJwW̍ŏl
	 */
	protected double getMin() {
		return m_min;
	}

	/**
	 * Ot\eNjJwW̍ŏlݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_min Ot\eNjJwW̍ŏl
	 */
	protected void setMin(double p_min) {
		m_min = p_min;
	}

	/**
	 * Ot\eNjJwWԂ܂B
	 * 
	 * @since 2.60
	 * @return Ot\eNjJwW
	 */
	protected IndexObjectList<?> getSrcList() {
		return m_srcList;
	}

	/**
	 * wWƎwW`GA̍̔䗦Ԃ܂B
	 * 
	 * @since 2.60
	 * @param p_panelHeight pl̍
	 * @return wWƎwW`GA̍̔䗦
	 */
	private double getRatio(int p_panelHeight) {
		// wW`GA̍Zo
		double indexViewHeight = (p_panelHeight * m_heightRatio / 100) - (m_titleBarTopOffset + m_titleBarHeight + m_indexTopOffset);
    	// wWl̕ϓZo
		double srcLineRange = m_max - m_min;
		// wWƎwW`GA̍̔䗦Ԃ
		return indexViewHeight / srcLineRange;
    }

	/**
	 * C̏[YWݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_top C̏[YW
	 */
	protected void setTop(int p_top) {
		m_top = p_top;
	}

	/**
	 * C̏[YWԂ܂B
	 * 
	 * @since 2.60
	 * @return C̏[YW
	 */
	protected int getTop() {
		return m_top;
	}

	/**
	 * ^Cgo[̏[YWԂ܂B
	 * 
	 * @since 2.60
	 * @return ^Cgo[̏[YW
	 */
	public int getTitleBarTop() {
		return m_top + m_titleBarTopOffset;
	}

	/**
	 * eNjJwW`GA[YWԂ܂B
	 * 
	 * @since 2.60
	 * @return eNjJwW`GA[YW
	 */
	public int getIndexTop() {
		return getTitleBarTop() + m_titleBarHeight + m_indexTopOffset;
	}

	/**
	 * Oɕ`悵wW̃^OieNjJwW`悷鎞Ɏgjݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_prevTag Oɕ`悵wW̃^OieNjJwW`悷鎞Ɏgj
	 */
	protected void setPrevTag(Tag p_prevTag) {
		m_prevTag = p_prevTag;
	}

	/**
	 * Oɕ`悵wW̃^OieNjJwW`悷鎞ɎgjԂ܂B
	 * 
	 * @since 2.60
	 * @return Oɕ`悵wW̃^OieNjJwW`悷鎞Ɏgj
	 */
	protected Tag getPrevTag() {
		return m_prevTag;
	}

	/**
	 * w肵eNjJwWlYWZoB
	 * 
	 * @since 2.60
	 * @param p_value eNjJwWl
	 * @param p_panelHeight pl̍
	 * @return w肵eNjJwWlɑ΂YW
	 */
	protected int calcY(double p_value, int p_panelHeight) {
		return ((int)((getMax()-p_value) * getRatio(p_panelHeight))) + getIndexTop();
	}

	/**
	 * w肵eNjJwWl̕YW̕ɕϊB
	 * 
	 * @since 2.60
	 * @param p_distance eNjJwWl̕
	 * @param p_panelHeight pl̍
	 * @return w肵eNjJwWl̕ɑ΂YW̕
	 */
	protected int calcYDistance(double p_distance, int p_panelHeight) {
		return (int)(p_distance * getRatio(p_panelHeight));
	}

	/**
	 * _ȉ̌ݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_indexScale _ȉ̌
	 */
	public void setIndexScale(int p_indexScale) {
		m_indexScale = p_indexScale;
	}
	
	/**
	 * _ȉ̌Ԃ܂B
	 * 
	 * @since 2.60
	 * @return _ȉ̌
	 */
	public int getIndexScale() {
		return m_indexScale;
	}

	/**
	 * I[o[bvԍԂ܂B
	 * ̃eNjJwWd˂ĕ\ꍇɓlZbg܂B
	 * XgœI[o[bvԍꍇɏdˍ킹ĕ`悳܂B
	 * GraphLayerListœI[o[bvԍAĂKv܂B
	 * 
	 * @since 2.60
	 * @return I[o[bvԍ
	 */
	public int getOverLapNo() {
		return m_overLapNo;
	}

	/**
	 * ^Cgo[̍Ԃ܂B
	 * 
	 * @since 2.60
	 * @return ^Cgo[̍
	 */
	protected int getTitleBarHeight() {
		return m_titleBarHeight;
	}

	/**
	 * ^Cgo[̍ݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_titleBarHeight ^Cgo[̍
	 */
	protected void setTitleBarHeight(int p_titleBarHeight) {
		m_titleBarHeight = p_titleBarHeight;
	}

	/**
	 * C̏[^Cgo[[܂ł̋Ԃ܂B
	 * 
	 * @since 2.60
	 * @return C̏[^Cgo[[܂ł̋
	 */
	protected int getTitleBarTopOffset() {
		return m_titleBarTopOffset;
	}

	/**
	 * C̏[^Cgo[[܂ł̋ݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_titleBarTopOffset C̏[^Cgo[[܂ł̋
	 */
	protected void setTitleBarTopOffset(int p_titleBarTopOffset) {
		m_titleBarTopOffset = p_titleBarTopOffset;
	}

	/**
	 * ^Cgo[̉[eNjJwW`GA[܂ł̗]Ԃ܂B
	 * 
	 * @since 2.60
	 * @return ^Cgo[̉[eNjJwW`GA[܂ł̗]
	 */
	protected int getIndexTopOffset() {
		return m_indexTopOffset;
	}

	/**
	 * ^Cgo[̉[eNjJwW`GA[܂ł̗]ݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_indexTopOffset ^Cgo[̉[eNjJwW`GA[܂ł̗]
	 */
	protected void setIndexTopOffset(int p_indexTopOffset) {
		m_indexTopOffset = p_indexTopOffset;
	}

	/**
	 * eNjJwW`悷FԂ܂B
	 * [\N̏ꍇ͘gqQ̐̕FB
	 * 
	 * @since 2.60
	 * @return eNjJwW`悷F
	 */
	public Color getForeColor() {
		return m_foreColor;
	}

	/**
	 * eNjJwW`悷Fݒ肵܂B
	 * [\N̏ꍇ͘gqQ̐̕FB
	 * 
	 * @since 2.60
	 * @param p_foreColor eNjJwW`悷F
	 */
	public void setForeColor(Color p_foreColor) {
		m_foreColor = p_foreColor;
	}

	/**
	 * ڍ׏̐FƓFŕ`悷ꍇtrueԂ܂B
	 * |WV̎ށiAjŐFꍇɎgp܂B
	 * 
	 * @since 2.60
	 * @return ڍ׏̐FƓFŕ`悷ꍇtrue
	 */
	public boolean isStatusColor() {
		return m_statusColor;
	}

	/**
	 * ڍ׏̐FƓFŕ`悷ꍇtrueݒ肵܂B
	 * |WV̎ށiAjŐFꍇɎgp܂B
	 * 
	 * @since 2.60
	 * @param p_statusColor ڍ׏̐FƓFŕ`悷ꍇtrue
	 */
	public void setStatusColor(boolean p_statusColor) {
		m_statusColor = p_statusColor;
	}

	/**
	 * plɂ郌C̍䗦(1`100)Ԃ܂B
	 * pl̒ŃC%߂邩܂B
	 * 
	 * @since 2.60
	 * @return plɂ郌C̍䗦(1`100)
	 */
	public int getHeightRatio() {
		return m_heightRatio;
	}
	
	/**
	 * plɂ郌C̍䗦(1`100)ݒ肵܂B
	 * pl̒ŃC%߂邩܂B
	 * 
	 * @since 2.60
	 * @param p_heightRatio plɂ郌C̍䗦(1`100)
	 */
	public void setHeightRatio(int p_heightRatio) {
		m_heightRatio = p_heightRatio;
	}

	/**
	 * ڐԂ܂B
	 * 
	 * @since 2.60
	 * @return ڐ
	 */
	public GraphRuler getRuler() {
		return m_ruler;
	}

	/**
	 * ^Cgo[ɕ\镶Ԃ܂B
	 * 
	 * @since 2.60
	 * @return ^Cgo[ɕ\镶
	 */
	public String getTitle() {
		return m_title;
	}

	/**
	 * ^Cgo[ɕ\镶ݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_title ^Cgo[ɕ\镶
	 */
	public void setTitle(String p_title) {
		m_title = p_title;
	}

	/**
	 * I[o[bvŖڐ̓ƂꍇtrueԂ܂B
	 * 
	 * @since 2.60
	 * @return I[o[bvŖڐ̓Ƃꍇtrue
	 */
	public boolean isSyncRuler() {
		return m_syncRuler;
	}

	/**
	 * I[o[bvŖڐ̓Ƃꍇtrueݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_syncRuler I[o[bvŖڐ̓Ƃꍇtrue
	 */
	public void setSyncRuler(boolean p_syncRuler) {
		m_syncRuler = p_syncRuler;
	}

}
