/**
 * Copyright (C) 2009-2010 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.common;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * t֘A[eBeB
 * 
 * @since 2.05
 * @author Copyright (C) 2008-2010 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class UtilDateTime {

	/**
	 * [eBeBNX̂߃RXgN^͌J܂B
	 * 
	 * @since 2.05
	 */
	private UtilDateTime() {
	}
	
	/**
	 * ݂̓Ԃ܂iyyyyMMdd HH:mm ss`j
	 * 
	 * @since 2.05
	 * @return ݂̓iyyyyMMdd HH:mm ss`j
	 */
	static public String getNowDateTime() {
		Date date = new Date();
		SimpleDateFormat formatter;
		formatter = new SimpleDateFormat("yyyyMMdd HH:mm ss");
		return formatter.format(date);
	}
	
	/**
	 * ݂̎Ԃ܂iHH:mm ss`j
	 * 
	 * @since 2.05
	 * @return ݂̎iHH:mm ss`j
	 */
	static public String getNowTimeHHMMSS() {
		Date date = new Date();
		SimpleDateFormat formatter;
		formatter = new SimpleDateFormat("HH:mm ss");
		return formatter.format(date);
	}

	/**
	 * ݂̎Ԃ܂iHH:mm`j
	 * 
	 * @since 2.05
	 * @return ݂̎iHH:mm`j
	 */
	static public String getNowTimeHHMM() {
		Date date = new Date();
		SimpleDateFormat formatter;
		formatter = new SimpleDateFormat("HH:mm");
		return formatter.format(date);
	}
	
	/**
	 * ݂̓tԂ܂iyyyyMMdd`j
	 * 
	 * @since 2.05
	 * @return ݂̓tiyyyyMMdd`j
	 */
	static public String getDateYYYYMMDD() {
		Date date = new Date();
		SimpleDateFormat formatter;
		formatter = new SimpleDateFormat("yyyyMMdd");
		return formatter.format(date);
	}

	/**
	 * ݂̓tԂ܂idd`j
	 * 
	 * @since 2.52
	 * @return ݂̓tidd`j
	 */
	static public String getDateDD() {
		Date date = new Date();
		SimpleDateFormat formatter;
		formatter = new SimpleDateFormat("dd");
		return formatter.format(date);
	}

	/**
	 * J_[ɕϊ܂
	 * 
	 * @since 2.05
	 * @param p_yyyymmdd "yyyyMMdd"`̓t
	 * @return w肵tɑΉJ_[CX^X
	 */
	public static Calendar parseCalendar(String p_yyyymmdd) {
		Calendar returnValue = Calendar.getInstance();
		int year = Integer.parseInt(p_yyyymmdd.substring(0,4));
		int month = Integer.parseInt(p_yyyymmdd.substring(4,6))-1;
		int day = Integer.parseInt(p_yyyymmdd.substring(6,8));
		returnValue.set(year, month, day,0,0,0);
		return returnValue;
	}
	
}
