/**
 * Copyright (C) 2008-2011 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.awt.Color;
import java.io.PrintStream;
import java.io.Serializable;

/**
 * ׂẴeNjJwW̃X[p[NX
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2011 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public abstract class IndexObject implements Serializable {
	
	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * ^O
	 * 
	 * @since 1.00
	 */
	private Tag m_tag;
	
	/**
	 * ڍ׏
	 * 
	 * @since 2.60
	 */
	private String m_detail;
	
	/**
	 * ʕ\鎞̐F
	 * 
	 * @since 2.80
	 */
	private Color m_color;
	
	/**
	 * IndexObject𐶐܂B
	 * 
	 * @since 2.34
	 */
	public IndexObject() {
		m_tag = Tag.create();
		m_color = null;
	}
	
	/**
	 * IndexObject𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_tag ^O
	 */
	public IndexObject(Tag p_tag) {
		m_tag = p_tag;
		m_color = null;
	}
	
	/**
	 * w肵eNjJwWƓꍇtrueԂ܂B
	 * ꂩǂ̓^OŔ肵܂B
	 * 
	 * @since 2.60
	 * @param p_other Ώۂ̃eNjJwW
	 */
	@Override
	public boolean equals(Object p_other) {
		if (!(p_other instanceof IndexObject)) return false;
		IndexObject other = (IndexObject)p_other;
		return this.getTag().equals(other.getTag());
	}
	
	/**
	 * nbVR[hԂ܂B
	 * 
	 * @since 2.60
	 * @return nbVR[h
	 */
	@Override
	public int hashCode() {
		return this.getTag().hashCode();
	}
	
	/**
	 * ^Oݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_tag ^O
	 */
	public final void setTag(Tag p_tag) {
		m_tag = p_tag;
	}

	/**
	 * ^OԂ܂B
	 * 
	 * @since 1.00
	 * @return ^O
	 */
	public final Tag getTag() {
		return m_tag;
	}
	
	/**
	 * IuWFNgɊ܂܂鍀ږo͂܂B
	 * fobO鎞Ɏg܂B
	 * 
	 * @since 1.00
	 * @param p_out o͐Xg[
	 */
	public abstract void printHeader(PrintStream p_out);

	/**
	 * IuWFNgɊ܂܂lo͂܂B
	 * fobO鎞Ɏg܂B
	 * 
	 * @since 1.00
	 * @param p_out o͐Xg[
	 */
	public abstract void print(PrintStream p_out);

	/**
	 * IuWFNgɊ܂܂lXMLŕԂ܂B
	 * 
	 * @since 2.02
	 * @return lXML\
	 */
	public abstract String toXml();

	/**
	 * ڍ׏Ԃ܂B
	 * 
	 * @since 2.60
	 * @return ڍ׏
	 */
	public String getDetail() {
		return m_detail;
	}

	/**
	 * ڍ׏ݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_detail ڍ׏
	 */
	public void setDetail(String p_detail) {
		m_detail = p_detail;
	}
	
	/**
	 * ʕ\鎞̐FԂ܂B
	 * 
	 * @since 2.80
	 * @return ʕ\鎞̐F
	 */
	public Color getColor() {
		return m_color;
	}

	/**
	 * ʕ\鎞̐Fݒ肵܂B
	 * 
	 * @since 2.80
	 * @param p_color ʕ\鎞̐F
	 */
	public void setColor(Color p_color) {
		m_color = p_color;
	}
	
}
