/**
 * Copyright (C) 2009-2012 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;

/**
 * ͒lEl𒴂ĂꍇɎw肵VOio͂܂B
 * ĂȂꍇ̓ftHgVOio͂܂B
 * 
 * @since 2.20
 * @author Copyright (C) 2009-2011 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeSignalStream
@EnabledDefaultSignal
@EnabledOutputSignal
@GeneDefaultLabelList(values={"border"})
@InputComponentList(values={"@IndexLine"})
public class ExceedBorderSignal extends SignalStream {

	/**
	 * VAo[WID
	 *  
	 * @since 2.60
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * El
	 * 
	 * @since 2.20
	 */
	private final double m_border;
	
	/**
	 * ExceedBorderSignal𐶐܂B
	 * 
	 * @since 2.20
	 * @param p_label x
	 * @param p_priority Dx
	 * @param p_outputSignal ɏo͂VOi
	 * @param p_geneList p[^Xg
	 * @param p_borderLabel El̃p[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public ExceedBorderSignal(String p_label, int p_priority, NmSignal p_outputSignal, GeneList p_geneList,
			String p_borderLabel) throws GeneListException {
		super(p_label, p_priority, p_outputSignal);
		m_border = p_geneList.getGene(p_borderLabel).getDoubleValue();
		getPortList().add("@IndexLine",1);
	}

	@Override
	protected JudgmentResult getJudgmentResultSub() throws IndexStreamException {
		IndexStreamPort p = getPortList().get("@IndexLine");
		// null`FbN
		if (p==null)
			throw new IndexStreamException("Null Error");
		if (p.getIndexStream()==null) 
			return null;
		if (p.getIndexStream().getValues()==null) 
			return null;
		// CX^X`FbN
		if (!(p.getIndexStream().getValues() instanceof IndexLine))
			throw new IndexStreamException("Instance Error");
		// TCY`FbN
		IndexLine line = (IndexLine)p.getIndexStream().getValues();
		if (line.size()<1) {
			return null;
		}
		// VOi
		NmSignal returnValue = getDefaultSignal();
		if (line.getLast().getValue() > m_border) {
			returnValue = getOutputSignal();
		}
		return new JudgmentResult(line.getLast().getTag(),returnValue);
	}
	
}
