/**
 * Copyright (C) 2009-2011 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.SimpleLine;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexPoint;

/**
 * sꉿi~ςă[\N𐶐܂B
 * 
 * @since 2.00
 * @author Copyright (C) 2009-2011 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("CandleStickList")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"minute"})
public class CandleStickFactory extends CandleStickListStream {

	/**
	 * VAo[WID 
	 *  
	 * @since 2.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * ^Ce[u
	 *  
	 * @since 2.00
	 */
	private final CandleStickTimeTable m_timeTable;

	/**
	 * Õ[\N̓t
	 *  
	 * @since 2.70
	 */
	private String m_prevDate;

	/**
	 * Õ[\NGA
	 *  
	 * @since 2.00
	 */
	private int m_prevArea;

	/**
	 * ~σC
	 *  
	 * @since 2.00
	 */
	private SimpleLine m_accumulateLine;

	/**
	 * CandleStickFactory𐶐܂B
	 * 
	 * @since 2.00
	 * @param p_label x
	 * @param p_geneList p[^Xg
	 * @param p_minuteLabel ̕(minute)𓾂邽߂ɎgœKp[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 * @throws IndexStreamException [\N^C~O^Ce[ut@C̃ANZXɎsꍇ
	 */
	public CandleStickFactory(String p_label, GeneList p_geneList, String p_minuteLabel) 
		throws GeneListException, IndexStreamException {
		super(p_label);
		m_prevArea = -1;
		m_accumulateLine = new SimpleLine();
		Gene ccountRangeGene = p_geneList.getGene(p_minuteLabel);
		m_timeTable = new CandleStickTimeTable(ccountRangeGene.getIntValue());
		// eNjJwW̓|[gݒ
		getPortList().add("@IndexLine",1);
	}

	@Override
	public void notifyIndexSub() throws IndexStreamException {
		// eNjJwW̓|[g擾
		IndexStreamPort port = getPortList().get("@IndexLine");
		// CX^X`FbN
		if (!(port.getIndexStream().getValues() instanceof IndexLine)) {
			throw new IndexStreamException("Instance Error");
		}
		// GA擾
		IndexPoint last = (IndexPoint)port.getIndexStream().getValues().getLast();
		int area = m_timeTable.lookup(last.getTag().getTime());
		// GAςɃ[\N𐶐
		if (m_prevArea==-1) m_prevArea = area;
		if (m_prevDate==null) m_prevDate = last.getTag().getDate();
		if (m_prevArea!=area || !m_prevDate.equals(last.getTag().getDate())) {
			CandleStick c = createCandleStick(last.getTag(), m_accumulateLine);
			getValues().add(c);
			notifyIndexNext();
			m_accumulateLine = new SimpleLine();
			m_accumulateLine.addPoint(last);
			m_prevArea = area;
			m_prevDate = last.getTag().getDate();
		} else {
			m_accumulateLine.addPoint(last);
		}
	}
	
	/**
	 * [\N𐶐܂B
	 * 
	 * @since 2.00
	 * @param p_tag ^O
	 * @param p_src \[XC
	 */
	private CandleStick createCandleStick(Tag p_tag, IndexLine p_src) {
		// TCY`FbN
		if (p_src==null) return null;
		if (p_src.size()<=0) return null; 
		// [\N𐶐
		double open = p_src.get(0).getValue();
		double close = p_src.getLast().getValue();
		double high = p_src.getMax().getValue();
		double low = p_src.getMin().getValue();
		CandleStick c = new CandleStick(p_tag,open,high,low,close);
		return c;
	}	

}
