/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.html;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * jp.robotbrain.htmlpbP[W̋ʃ[eBeB
 *
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class UtilHtml {
	
	/**
	 * [eBeBNX̂߃RXgN^͌J܂B
	 * 
	 * @since 1.00
	 */
	private UtilHtml() {
	}

	/**
	 * Sp܂܂ꍇURLEncode
	 * 
	 * @since 1.00
	 * @param p_src ϊ
	 * @param p_charset SpGR[hۂ̕Zbgw肵܂B
	 * @see <a href=
	 * "http://docs.oracle.com/javase/7/docs/technotes/guides/intl/encoding.doc.html">
	 * Zbg</a>
	 * @return ϊ㕶
	 */
	protected static String encodeWideChar(String p_src, String p_charset) {
		try {
			byte[] bsrc = p_src.getBytes(p_charset);
			if (p_src.length()!=bsrc.length) {
				return URLEncoder.encode(p_src, p_charset);
			}
		} catch (UnsupportedEncodingException e) {
		}
		return p_src;
	}

	/**
	 * w肳ꂽړURLړURLֈړꍇ́Aړ̃tpXURLԂ܂B 
	 * 
	 * @since 1.00
	 * @param p_currentUrl ړ̃tpXURL
	 * @param p_nextUrl ړURLi΃pXw\j
	 * @return ړ̃tpXURL
	 * @throws HtmlFormException URL̕ϊɎsꍇ
	 */
	public static String moveURL(String p_currentUrl, String p_nextUrl) 
		throws HtmlFormException {
		String dir = "";
		String nextUrl = "";
		// ړURLtpXȂ炻̂܂ܕԂ
		if (p_nextUrl.indexOf("http://")==0 || p_nextUrl.indexOf("https://")==0)
			return p_nextUrl;
		// ړURL̃`FbN
		if (!checkUrl(p_currentUrl))
			throw new HtmlFormException("method:HtmlUtil.moveUrl-1 p_currentUrl=" + p_currentUrl
					+ " p_nextUrl=" + p_nextUrl);
		// ړURL̃fBNg𓾂
		dir = p_currentUrl.substring(0, p_currentUrl.lastIndexOf("/"));
		if (dir.length()<9) {
			dir = p_currentUrl;
		}
		// ړURL̃Jgw\L
		nextUrl = p_nextUrl.replaceAll("(?<![\\.])\\./", "");
		// ړ̎w肪Ȃꍇ
		if (p_nextUrl.length()<=0) return p_currentUrl;
		// ړURL̃fBNg΃pX̏ꍇ
		if (p_nextUrl.substring(0, 1).equals("/")) {
			String host = extractHost(p_currentUrl);
			if (host==null)
				throw new HtmlFormException("method:HtmlUtil.moveUrl-4 p_currentUrl=" + p_currentUrl
						+ " p_nextUrl=" + p_nextUrl);
			return host + p_nextUrl;
		} else {
			// ړURL̃fBNg΃pX̏ꍇ
			while (true) {
				int up = nextUrl.indexOf("../");
				if (up<0) break;
				if (up!=0)
					throw new HtmlFormException("method:HtmlUtil.moveUrl-2 p_currentUrl=" + p_currentUrl
							+ " p_nextUrl=" + p_nextUrl);
				dir = p_currentUrl.substring(0, dir.lastIndexOf("/"));
				if (!checkUrl(dir)) 
					throw new HtmlFormException("method:HtmlUtil.moveUrl-3 p_currentUrl=" + p_currentUrl
							+ " p_nextUrl=" + p_nextUrl);
				nextUrl = nextUrl.substring(3);
			}
			return dir + "/" + nextUrl;
		}
	}
	
	/**
	 * URLzXg𔲂o܂B
	 * 
	 * @since 1.10
	 * @param p_url URL
	 * @return URL̃zXgB"http://"+zXgBŌ"/"͂ȂB
	 */
	private static String extractHost(String p_url) {
		if (p_url.indexOf("http://")==0) {
			String host = p_url.substring(7);
			int pos = host.indexOf("/");
			if (pos<0) return p_url;
			return "http://" + host.substring(0,pos);
		} else if (p_url.indexOf("https://")==0) {
			String host = p_url.substring(8);
			int pos = host.indexOf("/");
			if (pos<0) return p_url;
			return "https://" + host.substring(0,pos);
		} else {
			return null;
		}
	}
	
	/**
	 * NGXg\URL`FbN܂B
	 * 
	 * @since 1.00
	 * @param p_url `FbNΏۂURL
	 * @return URLɖ肪ȂtrueԂ܂B
	 */
	private static boolean checkUrl(String p_url) {
		if (p_url.lastIndexOf("http://")<0 && p_url.lastIndexOf("https://")<0) 
			return false; 
		return true;
	}
	
}
