/**
 * Copyright (C) 2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.common;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * p[eBeB
 * 
 * @since 2.05
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class UtilString {

	/**
	 * [eBeBNX̂߃RXgN^͌J܂B
	 * 
	 * @since 2.05
	 */
	private UtilString() {
	}
	
	/**
	 * Ώۂ̕񂩂L[[hiK\jŌăqbgŏ̕Ԃ܂B
	 * 啶A͋ʂ܂B
	 * 
	 * @since 2.51
	 * @param p_src Ώۂ̕
	 * @param p_regex L[[hiK\j
	 * @param p_seq ߂lƂ镔K\̃V[PXw肵܂BL[[hiK\j̒̍ۊʂEɐV[PXłB
	 * Ƃ΁A\"ZZZ((A)(B(C)))ZZZ"́A5̃O[vɕނ܂B<br>
	 * seq=0 : ZZZ((A)(B(C)))ZZZ \S<br>
	 * seq=1 : ((A)(B(C)))<br>
	 * seq=2 : (A)<br>
	 * seq=3 : (B(C))<br>
	 * seq=4 : (C)<br>
	 * @return Ƀqbgŏ̕
	 */
	public static String findFirstRegexKeyword(String p_src, String p_regex, int p_seq) {
		String returnValue = "";
		Pattern p = Pattern.compile(p_regex, Pattern.CASE_INSENSITIVE | Pattern.DOTALL); 
		Matcher m = p.matcher(p_src);
		if (m.find()) {
			returnValue = m.group(p_seq);
		}
		return returnValue;
	}

	/**
	 * Ώۂ̕񂩂L[[hiK\jŌăqbgŌ̕Ԃ܂B
	 * 啶A͋ʂ܂B
	 * 
	 * @since 2.51
	 * @param p_src Ώۂ̕
	 * @param p_regex L[[hiK\j
	 * @param p_seq ߂lƂ镔K\̃V[PXw肵܂BL[[hiK\j̒̍ۊʂEɐV[PXłB
	 * Ƃ΁A\"ZZZ((A)(B(C)))ZZZ"́A5̃O[vɕނ܂B<br>
	 * seq=0 : ZZZ((A)(B(C)))ZZZ \S<br>
	 * seq=1 : ((A)(B(C)))<br>
	 * seq=2 : (A)<br>
	 * seq=3 : (B(C))<br>
	 * seq=4 : (C)<br>
	 * @return Ƀqbgŏ̕
	 */
	public static String findLastRegexKeyword(String p_src, String p_regex, int p_seq) {
		String returnValue = "";
		Pattern p = Pattern.compile(p_regex, Pattern.CASE_INSENSITIVE | Pattern.DOTALL); 
		Matcher m = p.matcher(p_src);
		while (m.find()) {
			returnValue = m.group(p_seq);
		}
		return returnValue;
	}
	
	/**
	 * ϊ(p_src)̒̃L[[h(p_regex)p_replacementŒu܂
	 * 
	 * @since 2.05
	 * @param p_src ϊ
	 * @param p_regex L[[hiK\j
	 * @param p_replacement u
	 * @return ϊ㕶
	 */
	public static String replace(String p_src, String p_regex, String p_replacement) {
		Pattern p = Pattern.compile(p_regex);
		Matcher m = p.matcher(p_src);
		return m.replaceAll(p_replacement);
	}

	/**
	 * pSpɕϊ܂
	 * 
	 * @since 2.05
	 * @param p_src p
	 * @return Sp
	 */
	public static String toWideNumber(String p_src) {
	    StringBuilder sb = new StringBuilder(p_src);
	    for (int i = 0; i < p_src.length(); i++) {
	      char c = p_src.charAt(i);
	      if (c >= '0' && c <= '9') {
	        sb.setCharAt(i, (char) (c - '0' + 'O'));
	      }
	    }
	    return sb.toString();
	}
	
	/**
	 * XMLŃVACYꂽIuWFNg𕜌܂B
	 * 
	 * @since 2.41
	 * @param p_srcXML IuWFNgXML\
	 * @return ꂽIuWFNg
	 * @throws IOException obt@̃N[YɎsꍇ
	 */
	public static Object toObject(String p_srcXML) throws IOException {
		InputStream inStr = new ByteArrayInputStream(p_srcXML.getBytes());
		BufferedInputStream inBuf = new BufferedInputStream(inStr);
		XMLDecoder inXml = new XMLDecoder(inBuf);
		Object returnValue = inXml.readObject(); 
		inXml.close();
		inBuf.close();
		inStr.close();
		return returnValue;
	}
	
	/**
	 * w肵IuWFNgXML\Ԃ܂B
	 * 
	 * @since 2.41
	 * @param p_src XML\錳̃IuWFNg
	 * @return w肵IuWFNgXML\
	 * @throws IOException obt@̃N[YɎsꍇ
	 */
	public static String toXML(Object p_src) throws IOException {
		ByteArrayOutputStream outStr = new ByteArrayOutputStream();
		XMLEncoder outXml = new XMLEncoder(outStr);
		outXml.writeObject(p_src);
		outXml.close(); 
		byte[] returnValue = outStr.toByteArray();
		outStr.close();
		return new String(returnValue);
	}

	/**
	 * ̉E[w肵폜܂B
	 * 
	 * @since 2.80
	 * @param p_value ϊ
	 * @param p_trimString E[폜镶
	 * @return ϊ㕶
	 */
	public static String rTrim(String p_src, String p_trimString) {
		String returnValue = p_src;
		while (true) {
			if (returnValue.endsWith(p_trimString)) {
				returnValue = returnValue.substring(0, returnValue.length()-p_trimString.length());
			} else {
				break;
			}
		}
		return returnValue;
	}
	
	/**
	 * w肵̏_ȉ̌Ԃ܂B
	 * 
	 * @since 2.80
	 * @param p_value _܂ޕ
	 * @return w肵̏_ȉ̌
	 */
	public static int getScaleLength(String p_value) {
		if (p_value==null) return 0;
		String value = p_value.trim();
		if (value.length()<2) return 0;
		int p = value.indexOf(".");
		if (p<1) return 0;
		String sscale = value.substring(p+1);
		if (Double.parseDouble(sscale)==0D) return 0;
		sscale =  rTrim(sscale, "0");
		return sscale.length();
	}

	/**
	 * w肵̐̌Ԃ܂B
	 * 
	 * @since 2.80
	 * @param p_value ̌߂镶
	 * @return w肵̐̌
	 */
	public static int getIntLength(String p_value) {
		if (p_value==null) return 0;
		String value = p_value.trim();
		int p = value.indexOf(".");
		if (p<1) return value.length();
		String sscale = value.substring(0,p);
		if (Double.parseDouble(sscale)==0D) return 0;
		return sscale.length();
	}
	
}
