/**
 * Copyright (C) 2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

/**
 * eLXgt@CǂݏNX
 * 
 * @since 2.10
 * @author Copyright (C) 2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class TextFile {

	/**
	 * t@C̃pX
	 * 
	 * @since 2.10
	 */
	private String m_filePath;

	/**
	 * Zbg
	 * 
	 * @since 2.10
	 */
	private String m_charset;

	/**
	 * s
	 * 
	 * @since 2.10
	 */
	public static final String LSP = System.getProperty("line.separator");
	
	/**
	 * TextFile𐶐܂B
	 * 
	 * @since 2.10
	 * @param p_filePath t@C̃pX
	 * @param p_charset Zbg
	 * @see <a href=
	 * "http://docs.oracle.com/javase/7/docs/technotes/guides/intl/encoding.doc.html">Zbg</a>
	 */
	public TextFile(String p_filePath, String p_charset) {
		m_filePath = p_filePath;
		m_charset = p_charset;
	}
	
	/**
	 * eLXgt@Cɏo͂܂Bt@Co͂̎ɉs܂B
	 * 
	 * @since 2.33
	 * @param p_line o͂e
	 * @param p_append ǉtO
	 * @return ɐtrueԂ܂B
	 */
	public boolean write(String p_line, boolean p_append) {
		try {
			File dest = new File(m_filePath);
			FileOutputStream fos = new FileOutputStream(dest,p_append); 
			OutputStreamWriter osw = new OutputStreamWriter(fos, m_charset);
			BufferedWriter bw = new BufferedWriter(osw);
			bw.write(p_line);
			bw.close();
			osw.close();
			fos.close();
			return true;
		} catch (FileNotFoundException e) {
			if (UtilFile.getLogger()!=null)
				UtilFile.getLogger().warning("FileNotFoundException: " + e.getMessage());
		} catch (UnsupportedEncodingException e) {
			if (UtilFile.getLogger()!=null)
				UtilFile.getLogger().warning("UnsupportedEncodingException: " + e.getMessage());
		} catch (IOException e) {
			if (UtilFile.getLogger()!=null)
				UtilFile.getLogger().warning("IOException: " + e.getMessage());
		}
		return false;
	}

	/**
	 * eLXgt@Cɏo͂܂Bt@Cɏo͂邽тɉs܂B
	 * 
	 * @since 2.33
	 * @param p_line o͂s
	 * @param p_append ǉtO
	 * @return ɐtrueԂ܂B
	 */
	public boolean writeln(String p_line, boolean p_append) {
		try {
			File dest = new File(m_filePath);
			FileOutputStream fos = new FileOutputStream(dest,p_append); 
			OutputStreamWriter osw = new OutputStreamWriter(fos, m_charset);
			BufferedWriter bw = new BufferedWriter(osw);
			bw.write(p_line);
			bw.newLine();
			bw.close();
			osw.close();
			fos.close();
			return true;
		} catch (FileNotFoundException e) {
			if (UtilFile.getLogger()!=null)
				UtilFile.getLogger().warning("FileNotFoundException: " + e.getMessage());
		} catch (UnsupportedEncodingException e) {
			if (UtilFile.getLogger()!=null)
				UtilFile.getLogger().warning("UnsupportedEncodingException: " + e.getMessage());
		} catch (IOException e) {
			if (UtilFile.getLogger()!=null)
				UtilFile.getLogger().warning("IOException: " + e.getMessage());
		}
		return false;
	}
	
	/**
	 * eLXgt@Cǂ݁At@C̓e𕶎ŕԂ܂B
	 * 
	 * @since 2.10
	 * @return t@C̓e̕BɎsꍇnullԂ܂B
	 */
	public String read() {
		StringBuilder returnValue = new StringBuilder();
		try {
			FileInputStream fis = new FileInputStream(m_filePath); 
			InputStreamReader isr = new InputStreamReader(fis, m_charset); 
			BufferedReader br = new BufferedReader(isr);
			while (br.ready()) {
				String line = br.readLine() + LSP;
				returnValue.append(line);
			}
			br.close();
			isr.close();
			fis.close();
		} catch (FileNotFoundException e) {
			if (UtilFile.getLogger()!=null)
				UtilFile.getLogger().warning("FileNotFoundException: " + e.getMessage());
			return null;
		} catch (IOException e) {
			if (UtilFile.getLogger()!=null)
				UtilFile.getLogger().warning("IOException: " + e.getMessage());
			return null;
		}
		return returnValue.toString();
	}

	/**
	 * t@C̃pXԂ܂B
	 * 
	 * @since 2.50
	 * @return t@C̃pX
	 */
	public String getFilePath() {
		return m_filePath;
	}

}
