/**
 * Copyright (C) 2009-2012 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

/**
 * t@XgCX[C̏ɂꍇɎw肵VOio͂܂B
 * ȊO̓ftHgVOio͂܂B
 * ܂A܂΍Ƃăt@XgCƃX[C̘w肵
 * ̎w肵l傫ȘɂȂꍇɃVOio͂邱Ƃł܂B
 * 
 * @since 2.20
 * @author Copyright (C) 2009-2011 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeSignalStream
@EnabledDefaultSignal
@EnabledOutputSignal
@InputComponentList(values={"slow@IndexLine","fast@IndexLine","*difference@IndexLine"})
public class CrossOverSignal extends CrossSignal {

	/**
	 * VAo[WID
	 *  
	 * @since 2.60
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * CrossOverSignal𐶐܂B
	 * 
	 * @since 2.20
	 * @param p_label x
	 * @param p_priority Dx
	 * @param p_outputSignal ɏo͂VOi
	 */
	public CrossOverSignal(String p_label, int p_priority, NmSignal p_outputSignal) {
		super(p_label, p_priority, p_outputSignal);
		getPortList().add("slow@IndexLine",1);
		getPortList().add("fast@IndexLine",1);
		getPortList().add("*difference@IndexLine",1);
	}

	@Override
	protected JudgmentResult getJudgmentResultSub() throws IndexStreamException {
		IndexStreamPort slow = getPortList().get("slow@IndexLine");
		IndexStreamPort fast = getPortList().get("fast@IndexLine");
		IndexStreamPort difference = getPortList().get("*difference@IndexLine");
		// portnull`FbN
		if (slow==null)
			throw new IndexStreamException("slow@IndexLine Port Null Error");
		if (fast==null)
			throw new IndexStreamException("fast@IndexLine Port Null Error");
		if (difference==null)
			throw new IndexStreamException("*difference@IndexLine Port Null Error");
		// Xgnull`FbN
		if (slow.getIndexStream()==null) return null;
		if (fast.getIndexStream()==null) return null;
		if (slow.getIndexStream().getValues()==null) return null;
		if (fast.getIndexStream().getValues()==null) return null;
		// CX^X`FbN
		if (!(slow.getIndexStream().getValues() instanceof IndexLine))
			throw new IndexStreamException("slow@IndexLine Instance Error");
		if (!(fast.getIndexStream().getValues() instanceof IndexLine))
			throw new IndexStreamException("fast@IndexLine Instance Error");
		// TCY`FbN
		IndexLine slowLine = (IndexLine)slow.getIndexStream().getValues();
		if (slowLine.size()<1) {
			return null;
		}
		IndexLine fastLine = (IndexLine)fast.getIndexStream().getValues();
		if (fastLine.size()<1) {
			return null;
		}
		// σ|[g`FbN
		IndexLine differenceLine = null;
		if (difference.getIndexStream()!=null) {
			// CX^X`FbN
			if (!(difference.getIndexStream().getValues() instanceof IndexLine))
				throw new IndexStreamException("*difference@IndexLine Instance Error");
			// TCY`FbN
			differenceLine = (IndexLine)difference.getIndexStream().getValues();
			if (differenceLine.size()<1) {
				return null;
			}
		}
		// VOi
		NmSignal returnValue = getDefaultSignal();
		double fastValue = fastLine.getLast().getValue();
		double slowValue = slowLine.getLast().getValue();
		double differenceValue = 0;
		if (differenceLine!=null) {
			differenceValue = differenceLine.getLast().getValue();
		}
		if (isCrossOver(fastValue, slowValue, differenceValue)) returnValue = getOutputSignal();
		return new JudgmentResult(fastLine.getLast().getTag(),returnValue);
	}
	
}
