/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneListException;

/**
 * `lCXg[
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2010 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("ChannelLowLine")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"ccount"})
public class ChannelLowLineStream extends IndexLineStream {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * `lC
	 * 
	 * @since 1.00
	 */
	private final ChannelLowLine m_channelLowLine;
	
	/**
	 * ChannelLowLineStream𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 * @param p_geneList p[^Xg
	 * @param p_ccountLabel `lCZô߂Ɏg[\Ñp[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public ChannelLowLineStream(String p_label, GeneList p_geneList, String p_ccountLabel) throws GeneListException {
		super(p_label);
		// p[^̎擾
		Gene ccountGene = p_geneList.getGene(p_ccountLabel);
		// `lC̐
		int cost = ccountGene.getIntValue();
		m_channelLowLine = new ChannelLowLine(cost);
		// eNjJwW̓|[gݒ
		getPortList().add("@CandleStickList",cost);
	}
	
	@Override
	public boolean notifyIndexSub() throws IndexStreamException {
		// eNjJwW̓|[g擾
		IndexStreamPort port = getPortList().get("@CandleStickList");
		// CX^X`FbN
		if (!(port.getIndexStream().getValues() instanceof CandleStickList)) {
			throw new IndexStreamException("Instance Error");
		}
		// |Cgǉ
		m_channelLowLine.addPoint((CandleStickList)port.getIndexStream().getValues());
		// ̃eNjJwWɒʒm
		return notifyIndexNext();
	}

	/**
	 * `lCԂ܂B
	 * 
	 * @since 1.00
	 * @return `lC
	 */
	@Override
	public ChannelLowLine getValues() {
		return m_channelLowLine;
	}

	@Override
	public ChannelLowLine getViewValues() {
		return m_channelLowLine;
	}
	
	@Override
	public void economizeMemory() {
		m_channelLowLine.setCapacity(getDestinationMaxCost());
	}

	@Override
	public void economizeMemory(int p_capacity) {
		int capacity = Math.max(p_capacity, getDestinationMaxCost());
		m_channelLowLine.setCapacity(capacity);
	}
	
}
