/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

/**
 * {W[oh̃Xg
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class BollingerBandList extends IndexObjectList<BollingerBand> {

	/**
	 * VAo[WID 
	 * 
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * W΍C
	 * 
	 * @since 1.00
	 */
	private final StdevLine m_stdevLine;
	
	/**
	 * Z^[C
	 * 
	 * @since 1.00
	 */
	private final SmaLine m_centerLine;

	/**
	 * {W[ohijЂw肵܂B
	 * 
	 * @since 1.00
	 */
	private final double m_sigmaHigh;

	/**
	 * {W[ohijЂw肵܂B
	 * 
	 * @since 1.00
	 */
	private final double m_sigmaLow;
	
	/**
	 * BollingerBandList𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_pcountCenter Z^[C(Pړ)Zô߂Ɏg|Cg
	 * @param p_pcountStdev W΍Zô߂Ɏg|Cg
	 * @param p_sigmaHigh {W[ohijЂw肵܂B
	 * @param p_sigmaLow {W[ohijЂw肵܂B
	 */
	public BollingerBandList(int p_pcountCenter, int p_pcountStdev, double p_sigmaHigh, double p_sigmaLow) {
		super(NmViewType.INVISIBLE);
		m_centerLine = new SmaLine(p_pcountCenter);
		m_stdevLine = new StdevLine(p_pcountStdev);
		m_sigmaHigh =p_sigmaHigh;
		m_sigmaLow = p_sigmaLow;
	}	

	@Override
	public void remove(String p_date) {
		super.remove(p_date);
		m_stdevLine.remove(p_date);
		m_centerLine.remove(p_date);
	}

	/**
	 * \[XC{W[ohZoăXgɒǉ܂B
	 * 
	 * @since 1.00
	 * @param p_src \[XC
	 */
	public void addObject(IndexLine p_src) {
		// TCY`FbN
		if (p_src==null) return;
		if (p_src.size()<=0) return; 
		// Z^[CƕW΍߂
		m_centerLine.addPoint(p_src);
		m_stdevLine.addPoint(p_src);
		// Z^[CƕW΍̃TCY`FbN
		if (!m_centerLine.isExist()) return;
		if (!m_stdevLine.isExist()) return;
		// {W[oh̐
		BollingerBand b 
			= new BollingerBand(p_src.getLast().getTag(),
					m_centerLine.getLast().getValue(),
					m_stdevLine.getLast().getValue(),
					m_sigmaHigh,m_sigmaLow
				);
		add(b);
	}
	
}
