/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

/**
 * RSIC
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class RsiLine extends IndexLine {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * RSIZô߂Ɏg|Cg
	 * 
	 * @since 1.00
	 */
	private final int m_pcount;

	/**
	 * RsiLine𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_pcount RSIZô߂Ɏg|Cg
	 */
	public RsiLine(int p_pcount) {
		super(NmViewType.INDEXLINE_PERCENTAGE);
		m_pcount = p_pcount;
	}
	
	/**
	 * \[XCRSIZoăCɒǉ܂B
	 * 
	 * @since 1.00
	 * @param p_src \[XC
	 */
	public void addPoint(IndexLine p_src) {
		// TCY`FbN
		if (p_src==null) return;
		if (p_src.size() < m_pcount) return;
		// wRSI߂
		IndexLine tail = p_src.getTailLine(m_pcount);
		double sumPlus = 0;
		double sumMinus = 0;
		double prevValue = 0;
		// ŏ1
		IndexPoint f = tail.get(0);
		if (f==null) return;
		prevValue = f.getValue();
		// 2ڈȍ~
		for (int i=1;i<tail.size();i++) {
			IndexPoint c = tail.get(i);
			if (prevValue<c.getValue()) {
				sumPlus += c.getValue() - prevValue;
			} else if (prevValue>c.getValue()) {
				sumMinus += prevValue - c.getValue();
			}
			prevValue = c.getValue();
		}
		double rsi = sumPlus / (sumPlus + sumMinus) * 100;
		// _ǉ
		IndexPoint lastPoint = p_src.getLast();
		add(new IndexPoint(lastPoint.getTag(),rsi));
	}	

}
