/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.html;

import java.io.PrintStream;
import java.io.Serializable;

/**
 * formɊ܂܂Ăinput^O(button^O܂)̏ێNX
 *
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class HtmlInput implements Serializable {

	/**
	 * VAo[Whc
	 * 
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * id
	 * 
	 * @since 1.00
	 */
	private String m_id;
	
	/**
	 * type
	 * 
	 * @since 1.00
	 */
	private String m_type;
	
	/**
	 * name
	 * 
	 * @since 1.00
	 */
	private String m_name;
	
	/**
	 * value
	 * 
	 * @since 1.00
	 */
	private String m_value;
	
	/**
	 * I
	 * 
	 * @since 1.00
	 */
	private boolean m_selected;
	
	/**
	 * HtmlInput𐶐܂B
	 * 
	 * @since 1.00
	 */
	public HtmlInput() {
	}

	/**
	 * idݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_id id
	 */
	public void setId(String p_id) {
		m_id = p_id;
	}

	/**
	 * idԂ܂B
	 * 
	 * @since 1.00
	 * @return id
	 */
	public String getId() {
		return m_id;
	}

	/**
	 * typeݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_type type
	 */
	public void setType(String p_type) {
		m_type = p_type.toLowerCase();
	}

	/**
	 * typeԂ܂B
	 * 
	 * @since 1.00
	 * @return type
	 */
	public String getType() {
		return m_type;
	}
	
	/**
	 * nameݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_name name
	 */
	public void setName(String p_name) {
		m_name = p_name;
	}

	/**
	 * nameԂ܂B
	 * 
	 * @since 1.00
	 * @return name
	 */
	public String getName() {
		return m_name;
	}

	/**
	 * valueݒ肵܂B
	 * 
	 * @since 1.00
	 * @param p_value value
	 */
	public void setValue(String p_value) {
		m_value = p_value;
	}

	/**
	 * valueԂ܂B
	 * 
	 * @since 1.00
	 * @return value
	 */
	public String getValue() {
		return m_value;
	}

	/**
	 * IԂݒ肵܂B
	 * submit,reset̏ꍇ̓NbNǂ܂B
	 * checkbox,radiȍꍇ̓`FbNĂ邩܂B
	 * 
	 * @since 1.00
	 * @param p_selected I
	 */
	public void setSelected(boolean p_selected) {
		m_selected = p_selected;
	}

	/**
	 * IԂԂ܂B
	 * submit,reset̏ꍇ̓NbNǂ܂B
	 * checkbox,radiȍꍇ̓`FbNĂ邩܂B
	 * 
	 * @since 1.00
	 * @return I
	 */
	public boolean isSelected() {
		return m_selected;
	}

	/**
	 * w肳ꂽinput^Oƌ`mF܂B
	 * 
	 * @since 1.00
	 * @param p_other input^O
	 * @return w肳ꂽinput^Oƌ`ꍇtrueԂ܂B
	 */
	public boolean equalsFormat(HtmlInput p_other) {
		if (!getId().equals(p_other.getId())) return false; 
		if (!getType().equals(p_other.getType())) return false; 
		if (!getName().equals(p_other.getName())) return false; 
		return true;	
	}
	
	/**
	 * input^Ȏ̓ew肵o̓Xg[ɏo͂܂B
	 * 
	 * @since 1.00
	 * @param p_out o̓Xg[
	 */
	public void print(PrintStream p_out) {
		p_out.println(m_id+"\t"+m_type+"\t"+m_name+"\t"+m_value+"\t"+m_selected);
	}
	
	/**
	 * ̃CX^XƓr܂B
	 * 
	 * @since 1.01
	 * @param p_other ̃CX^X
	 * @return ̃CX^XƓꍇtrue
	 */
	@Override
	public boolean equals(Object p_other) {
		if (!(p_other instanceof HtmlInput)) return false;  
		HtmlInput other = (HtmlInput)p_other;
		if (!getId().equals(other.getId())) return false; 
		if (!getType().equals(other.getType())) return false; 
		if (!getName().equals(other.getName())) return false; 
		if (!getValue().equals(other.getValue())) return false; 
		return true;	
	}
	
	/**
	 * nbVR[hԂ܂B
	 * 
	 * @since 1.01
	 */
	@Override
	public int hashCode() {
		String hash = getId() + getType() + getName() + getValue();
		return hash.hashCode();
	}
	
}
