/**
 * Copyright (C) 2008-2011 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.EmaLine;
import jp.robotbrain.signal.IndexLine;

/**
 * EMACXg[
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2011 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("EmaLine")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"pcount"})
public class EmaLineStream extends IndexLineStream {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * EMAC
	 * 
	 * @since 1.00
	 */
	private final EmaLine m_emaLine;
	
	/**
	 * EmaLineStream𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 * @param p_geneList p[^Xg
	 * @param p_pcountLabel EMAZô߂Ɏg|Cg̃p[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public EmaLineStream(String p_label, GeneList p_geneList, String p_pcountLabel) throws GeneListException {
		super(p_label);
		// p[^̎擾
		Gene pcountGene = p_geneList.getGene(p_pcountLabel);
		// EMAC̐
		int cost = pcountGene.getIntValue();
		m_emaLine = new EmaLine(cost);
		// eNjJwW̓|[gݒ
		getPortList().add("@IndexLine",cost);
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#notifyIndexSub()
	 */
	@Override
	public void notifyIndexSub() throws IndexStreamException {
		// eNjJwW̓|[g擾
		IndexStreamPort port = getPortList().get("@IndexLine");
		// CX^X`FbN
		if (!(port.getIndexStream().getValues() instanceof IndexLine)) {
			throw new IndexStreamException("Instance Error");
		}
		// |Cgǉ
		m_emaLine.addPoint((IndexLine)port.getIndexStream().getValues());
		// ̃eNjJwWɒʒm
		notifyIndexNext();
	}

	/**
	 * EMACԂ܂B
	 * 
	 * @since 1.00
	 * @return EMAC
	 */
	@Override
	public EmaLine getValues() {
		return m_emaLine;
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#economizeCapacity()
	 */
	@Override
	public void economizeCapacity() {
		m_emaLine.setCapacity(getDestinationMaxCost());
	}
	
}
