/**
 * Copyright (C) 2010 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneListException;

/**
 * h``l̍lƈl̍̃Xg[
 * 
 * @since 2.50
 * @author Copyright (C) 2010 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("SimpleLine")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"ccount"})
public class HighLowDifferenceLineStream extends IndexLineStream {

	/**
	 * VAo[WID
	 *  
	 * @since 2.50
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * h``l̍lƈl̍̃C
	 * 
	 * @since 2.50
	 */
	private final SimpleLine m_HighLowDifferenceLine;
	
	/**
	 * `lドC
	 * 
	 * @since 2.50
	 */
	private final ChannelHighLine m_channelHighLine;

	/**
	 * `lC
	 * 
	 * @since 2.50
	 */
	private final ChannelLowLine m_channelLowLine;
	
	/**
	 * eNjJwWZô߂ɕKvƂ̓eNjJwW̐
	 * 
	 * @since 2.50
	 */
	private int m_cost;

	/**
	 * HighLowDifferenceStream𐶐܂B
	 * 
	 * @since 2.50
	 * @param p_label x
	 * @param p_geneList p[^Xg
	 * @param p_ccountLabel `lドCƉCZô߂Ɏg[\Ñp[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public HighLowDifferenceLineStream(String p_label, GeneList p_geneList, String p_ccountLabel) throws GeneListException {
		super(p_label);
		// p[^̎擾
		Gene ccountGene = p_geneList.getGene(p_ccountLabel);
		// `lドC̐
		m_cost = ccountGene.getIntValue();
		m_HighLowDifferenceLine = new SimpleLine();
		m_channelHighLine = new ChannelHighLine(m_cost);
		m_channelLowLine = new ChannelLowLine(m_cost);
	}
	
	/**
	 * Xg[̓
	 * 
	 * @since 2.50
	 * @param p_src \[X[\NXg
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	public void enter(CandleStickList p_src) throws IndexStreamException {
		notifyIndex(p_src);
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#notifyIndexSub(jp.robotbrain.signal.IndexObjectList)
	 */
	@Override
	public void notifyIndexSub(IndexObjectList<?> p_indexObjectList)
			throws IndexStreamException {
		// CX^X`FbN
		if (!(p_indexObjectList instanceof CandleStickList)) {
			throw new IndexStreamException("Instance Error");
		}
		// |Cgǉ
		m_channelHighLine.addPoint((CandleStickList)p_indexObjectList);
		m_channelLowLine.addPoint((CandleStickList)p_indexObjectList);
		if (p_indexObjectList.size()>0) {
			Tag tag = p_indexObjectList.getLast().getTag();
			if (m_channelHighLine.size()>0 && m_channelLowLine.size()>0) {
				double high = m_channelHighLine.getLast().getValue();
				double low = m_channelLowLine.getLast().getValue();
				m_HighLowDifferenceLine.addPoint(new IndexPoint(tag,high-low));
			} else {
				m_HighLowDifferenceLine.addPoint(new IndexPoint(tag,0));
			}
		}
		// ̃eNjJwWɒʒm
		notifyIndexNext(m_HighLowDifferenceLine);
	}

	/**
	 * h``l̍lƈl̍Ԃ܂B
	 * 
	 * @since 2.50
	 * @return `lドC
	 */
	@Override
	public SimpleLine getValues() {
		return m_HighLowDifferenceLine;
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStreamDestination#getCost()
	 */
	@Override
	public int getCost() {
		return m_cost;
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#economizeCapacity()
	 */
	@Override
	public void economizeCapacity() {
		m_HighLowDifferenceLine.setCapacity(getDestinationMaxCost());
		m_channelHighLine.setCapacity(getDestinationMaxCost());
		m_channelLowLine.setCapacity(getDestinationMaxCost());
	}
	
}
