/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.io.Serializable;
import java.util.ArrayList;

import jp.robotbrain.signal.IndexObjectList;

/**
 * ׂẴeNjJwWXg[̃X[p[NX
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public abstract class IndexStream extends TradeComponent implements Serializable, IndexStreamDestination {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * eNjJwWʒm惊Xg
	 * 
	 * @since 1.00
	 */
	private final ArrayList<IndexStreamDestination> m_destinationList;
	
	/**
	 * ŌɒʒmꂽeNjJwW̃^O
	 * 
	 * @since 2.40
	 */
	private Tag m_prevTag;

	/**
	 * eNjJwWʒm̒ōő̃RXgiKvƂ̓eNjJwW̐j
	 * 
	 * @since 2.40
	 */
	private int m_destinationMaxCost;

	/**
	 * IndexStream𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 */
	public IndexStream(String p_label) {
		super(p_label);
		m_destinationList = new ArrayList<IndexStreamDestination>();
	}

	/**
	 * eNjJwW̒ʒm܂B
	 * 
	 * @since 2.40
	 * @param p_indexObjectList eNjJwW̃Xg
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	@Override
	public final void notifyIndex(IndexObjectList<?> p_indexObjectList) 
		throws IndexStreamException {
		// null`FbN
		if (p_indexObjectList==null) {
			throw new IndexStreamException("Null Error");
		}
		// TCY`FbN
		if (p_indexObjectList.size()<=0) {
			return;
		}
		// qNXpĂяo
		notifyIndexSub(p_indexObjectList);
	}

	/**
	 * qNXɃeNjJwW̒ʒm܂B
	 * 
	 * @since 2.40
	 * @param p_indexObjectList eNjJwW̃Xg
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	protected abstract void notifyIndexSub(IndexObjectList<?> p_indexObjectList)
		throws IndexStreamException;
	
	/**
	 * O`FbÑ^OƓꍇtrueԂ܂B
	 * 
	 * @since 2.40
	 * @param p_tag `FbNΏۂ̃eNjJwWXg
	 * @return O`FbÑ^OƓꍇtrue
	 */
	protected boolean isTagChanged(IndexObjectList<?> p_indexObjectList) {
		if (p_indexObjectList.size()<=0) return false;
		Tag tag = p_indexObjectList.getLast().getTag();
		boolean returnValue = !tag.equals(m_prevTag);
		m_prevTag = tag;
		return returnValue;
	}
	
	/**
	 * ʒmɃeNjJwWn܂B
	 * 
	 * @since 1.00
	 * @param p_indexObjectList eNjJwW̃Xg
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	protected final void notifyIndexNext(IndexObjectList<?> p_indexObjectList) 
		throws IndexStreamException {
		if (isTagChanged(p_indexObjectList)) {
			for (IndexStreamDestination i: m_destinationList) {
				if (i!=null) {
					i.notifyIndex(p_indexObjectList);
				}
			}
		}
	}

	/**
	 * eNjJwW̃XgԂ܂B
	 * 
	 * @since 1.00
	 * @return eNjJwW̃Xg
	 */
	public abstract IndexObjectList<?> getValues(); 
	
	/**
	 * ʒmǉ܂B
	 * 
	 * @since 1.00
	 * @param p_indexStream ʒm
	 */
	public final void addDestination(IndexStreamDestination p_indexStream) {
		m_destinationList.add(p_indexStream);
		if (p_indexStream.getCost()>m_destinationMaxCost) {
			m_destinationMaxCost = p_indexStream.getCost();
		}
	}
	
	/**
	 * eNjJwWʒm̒ōő̃RXgiKvƂeNjJwW̐jݒ肵܂B
	 * 
	 * @since 2.40
	 * @param p_destinationMaxCost eNjJwWʒm̒ōő̃RXgiKvƂeNjJwW̐j
	 */
	protected void setDestinationMaxCost(int p_destinationMaxCost) {
		m_destinationMaxCost = p_destinationMaxCost;
	}

	/**
	 * eNjJwWʒm̒ōő̃RXgiKvƂeNjJwW̐jԂ܂B
	 * 
	 * @since 2.40
	 * @return eNjJwWʒm̒ōő̃RXgiKvƂeNjJwW̐j
	 */
	public int getDestinationMaxCost() {
		return m_destinationMaxCost;
	}
	
	/**
	 * eNjJwW̕ێʂ\Ȍ菬ăʂ}B
	 * 
	 * @since 2.40
	 */
	public abstract void economizeCapacity();

	/**
	 * Xg[Ɋ܂܂邷ׂẴeNjJwWXML\Ԃ܂B
	 * 
	 * @since 2.02
	 * @return Xg[Ɋ܂܂邷ׂẴeNjJwWXML\
	 */
	public final String toXml() {
		if (getValues().size()<=0) return "";
		StringBuilder returnValue = new StringBuilder();
		returnValue.append("<component label=\"");
		returnValue.append(getLabel());
		returnValue.append("\">");
		returnValue.append(getValues().toXml());
		returnValue.append("</component>");
		return returnValue.toString();
	}
	
}
