/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.StdevLine;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexObjectList;

/**
 * W΍CXg[
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2010 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("StdevLine")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"pcount"})
public class StdevLineStream extends IndexLineStream {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * W΍C
	 * 
	 * @since 1.00
	 */
	private final StdevLine m_stdevLine;

	/**
	 * eNjJwWZô߂ɕKvƂ̓eNjJwW̐
	 * 
	 * @since 2.40
	 */
	private int m_cost;
	
	/**
	 * StdevLineStream𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 * @param p_geneList p[^Xg
	 * @param p_pcountLabel W΍Zô߂Ɏg|Cg̃p[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public StdevLineStream(String p_label, GeneList p_geneList, String p_pcountLabel) throws GeneListException {
		super(p_label);
		// p[^̎擾
		Gene pcountGene = p_geneList.getGene(p_pcountLabel);
		// W΍C̐
		m_cost = pcountGene.getIntValue();
		m_stdevLine = new StdevLine(m_cost);
	}

	/**
	 * Xg[̓
	 * 
	 * @since 1.00
	 * @param p_src \[XC
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	public void enter(IndexLine p_src) throws IndexStreamException {
		notifyIndex(p_src);
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#notifyIndexSub(jp.robotbrain.signal.IndexObjectList)
	 */
	@Override
	public void notifyIndexSub(IndexObjectList<?> p_indexObjectList)
			throws IndexStreamException {
		// CX^X`FbN
		if (!(p_indexObjectList instanceof IndexLine)) {
			throw new IndexStreamException("Instance Error");
		}
		// |Cgǉ
		m_stdevLine.addPoint((IndexLine)p_indexObjectList);
		// ̃eNjJwWɒʒm
		notifyIndexNext(m_stdevLine);
	}

	/**
	 * W΍C
	 * 
	 * @since 1.00
	 * @return W΍CԂ܂B
	 */
	@Override
	public StdevLine getValues() {
		return m_stdevLine;
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStreamDestination#getCost()
	 */
	@Override
	public int getCost() {
		return m_cost;
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#economizeCapacity()
	 */
	@Override
	public void economizeCapacity() {
		m_stdevLine.setCapacity(getDestinationMaxCost());
	}

}
