/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneListException;

/**
 *`lドCXg[
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2010 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("ChannelHighLine")
@InputComponentList(values={"@CandleStickList"})
@GeneDefaultLabelList(values={"ccount"})
public class ChannelHighLineStream extends IndexLineStream {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * `lドC
	 * 
	 * @since 1.00
	 */
	private final ChannelHighLine m_channelHighLine;
	
	/**
	 * eNjJwWZô߂ɕKvƂ̓eNjJwW̐
	 * 
	 * @since 2.40
	 */
	private int m_cost;

	/**
	 * ChannelHighLineStream𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 * @param p_geneList p[^Xg
	 * @param p_ccountLabel `lドCZô߂Ɏg[\Ñp[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public ChannelHighLineStream(String p_label, GeneList p_geneList, String p_ccountLabel) throws GeneListException {
		super(p_label);
		// p[^̎擾
		Gene ccountGene = p_geneList.getGene(p_ccountLabel);
		// `lドC̐
		m_cost = ccountGene.getIntValue();
		m_channelHighLine = new ChannelHighLine(m_cost);
	}
	
	/**
	 * Xg[̓
	 * 
	 * @since 1.00
	 * @param p_src \[X[\NXg
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	public void enter(CandleStickList p_src) throws IndexStreamException {
		notifyIndex(p_src);
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#notifyIndexSub(jp.robotbrain.signal.IndexObjectList)
	 */
	@Override
	public void notifyIndexSub(IndexObjectList<?> p_indexObjectList)
			throws IndexStreamException {
		// CX^X`FbN
		if (!(p_indexObjectList instanceof CandleStickList)) {
			throw new IndexStreamException("Instance Error");
		}
		// |Cgǉ
		m_channelHighLine.addPoint((CandleStickList)p_indexObjectList);
		// ̃eNjJwWɒʒm
		notifyIndexNext(m_channelHighLine);
	}

	/**
	 * `lドCԂ܂B
	 * 
	 * @since 1.00
	 * @return `lドC
	 */
	@Override
	public ChannelHighLine getValues() {
		return m_channelHighLine;
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStreamDestination#getCost()
	 */
	@Override
	public int getCost() {
		return m_cost;
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#economizeCapacity()
	 */
	@Override
	public void economizeCapacity() {
		m_channelHighLine.setCapacity(getDestinationMaxCost());
	}
	
}
