/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.IndexObjectList;

/**
 * IlCXg[
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2010 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("CandleStickCloseLine")
@InputComponentList(values={"@CandleStickList"})
public class CandleStickCloseLineStream extends IndexLineStream {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * IlC
	 * 
	 * @since 1.00
	 */
	private final CandleStickCloseLine m_candleStickCloseLine;

	/**
	 * CandleStickCloseLineStream𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 */
	public CandleStickCloseLineStream(String p_label) {
		super(p_label);
		// IlC
		m_candleStickCloseLine = new CandleStickCloseLine();
	}
	
	/**
	 * Xg[̓
	 * 
	 * @since 1.00
	 * @param p_src \[X[\NXg
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	public void enter(CandleStickList p_src) throws IndexStreamException {
		notifyIndex(p_src);
	}
	
	@Override
	public void notifyIndexSub(IndexObjectList<?> p_indexObjectList)
			throws IndexStreamException {
		// CX^X`FbN
		if (!(p_indexObjectList instanceof CandleStickList)) {
			throw new IndexStreamException("Instance Error");
		}
		// |Cgǉ
		m_candleStickCloseLine.addPoint((CandleStick)p_indexObjectList.getLast());
		// ̃eNjJwWɒʒm
		notifyIndexNext(m_candleStickCloseLine);
	}

	/**
	 * IlCԂ܂B
	 * 
	 * @since 1.00
	 * @return IlC
	 */
	@Override
	public CandleStickCloseLine getValues() {
		return m_candleStickCloseLine;
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStreamDestination#getCost()
	 */
	@Override
	public int getCost() {
		return 1;
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#economizeCapacity()
	 */
	@Override
	public void economizeCapacity() {
		m_candleStickCloseLine.setCapacity(getDestinationMaxCost());
	}
	
}
