/**
 * Copyright (C) 2010 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

/**
 * oEhmubNBXJbgVOi烊oEh
 * ܂ŃCVOiՒfB
 * 
 * @since 2.33
 * @author Copyright (C) 2010 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeSignalBlock
@InputComponentList(values={"main@Signal","losscut@Signal","reverse@Signal"})
public class ReverseSwitch extends SignalBlock {

	/**
	 * ꎞۑpXJbgVOi
	 * 
	 * @since 2.33
	 */
	private NmSignal m_saveLossCutSignal;
	
	/**
	 * ReverseSwitch𐶐܂B
	 * 
	 * @since 2.33
	 * @param p_label x
	 * @param p_priority Dx
	 */
	public ReverseSwitch(String p_label, int p_priority) {
		super(p_label, p_priority);
		m_saveLossCutSignal = NmSignal.NOSIGNAL;
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.SignalBlock#getJudgmentResultSub()
	 */
	@Override
	protected JudgmentResult getJudgmentResultSub() throws IndexStreamException {
		// ̓VOi̎擾
		Signal main = lookupInputSignal("main@Signal");
		Signal losscut = lookupInputSignal("losscut@Signal");
		Signal reverse = lookupInputSignal("reverse@Signal");
		// ŐV^O̎擾
		Tag inputTag = getInputTag();
		if (inputTag==null) return new JudgmentResult(null,NmSignal.NOSIGNAL);
		// VOi
		NmSignal returnValue = main.getJudgmentResult().getSignal();
		NmSignal losscutSignal = losscut.getJudgmentResult().getSignal();
		NmSignal reverseSignal = reverse.getJudgmentResult().getSignal();
		if (m_saveLossCutSignal==NmSignal.NOSIGNAL) {
			if (losscutSignal==NmSignal.ESCAPE) {
				// XJbg炻̎̃VOiۑ
				m_saveLossCutSignal = returnValue;
				// CVOiՒf
				returnValue = NmSignal.NOSIGNAL;
			}
		} else {
			if (reverseSignal==m_saveLossCutSignal) {
				// oEh珉
				m_saveLossCutSignal = NmSignal.NOSIGNAL;
			} else {
				// XJbgĂāAoEhĂȂꍇ̓CVOiՒf
				returnValue = NmSignal.NOSIGNAL;
			}
		}
		setDetails(returnValue.toString());
		return new JudgmentResult(inputTag,returnValue);
	}
	
	/**
	 * w肵|[gx̓VOiԂ܂B
	 * 
	 * @param p_portLabel ̓|[gx
	 * @return ̓VOi
	 * @throws IndexStreamException ̓VOiȂꍇ
	 */
	private Signal lookupInputSignal(String p_portLabel) throws IndexStreamException {
		for (Signal returnValue: getInputSignalList()) {
			if (returnValue.isExistDestination(p_portLabel)) 
				return returnValue;
		}
		throw new IndexStreamException(getLabel() + " Not Found Input Port Label: " + p_portLabel);
	}
	
}
