/**
 * Copyright (C) 2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;

/**
 * ͒lEl𒴂ĂꍇɎw肵VOio͂܂B
 * ĂȂꍇ̓ftHgVOio͂܂B
 * 
 * @since 2.20
 * @author Copyright (C) 2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeSignalStream
@EnabledDefaultSignal
@EnabledOutputSignal
@GeneDefaultLabelList(values={"border"})
@InputComponentList(values={"@IndexLine"})
public class ExceedBorderSignal extends SignalStream {

	/**
	 * El
	 * 
	 * @since 2.20
	 */
	private final double m_border;
	
	/**
	 * ExceedBorderSignal𐶐܂B
	 * 
	 * @since 2.20
	 * @param p_label x
	 * @param p_priority Dx
	 * @param p_outputSignal ɏo͂VOi
	 * @param p_geneList p[^Xg
	 * @param p_borderLabel El̃p[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public ExceedBorderSignal(String p_label, int p_priority, NmSignal p_outputSignal, GeneList p_geneList,
			String p_borderLabel) throws GeneListException {
		super(p_label, p_priority, p_outputSignal);
		m_border = p_geneList.getGene(p_borderLabel).getDoubleValue();
		getPortList().add("@IndexLine",1);
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.Signal#getJudgmentResultSub()
	 */
	@Override
	protected JudgmentResult getJudgmentResultSub() throws IndexStreamException {
		IndexStreamPort p = getPortList().get("@IndexLine");
		// null`FbN
		if (p==null)
			throw new IndexStreamException("Null Error");
		if (p.getObjectList()==null) 
			return new JudgmentResult(null,NmSignal.NOSIGNAL);
		// CX^X`FbN
		if (!(p.getObjectList() instanceof IndexLine))
			throw new IndexStreamException("Instance Error");
		// TCY`FbN
		IndexLine line = (IndexLine)p.getObjectList();
		if (line.size()<1) {
			setDetails(NmSignal.NOSIGNAL.toString());
			return new JudgmentResult(null,NmSignal.NOSIGNAL);
		}
		// VOi
		NmSignal returnValue = getDefaultSignal();
		if (line.getLast().getValue() > m_border) {
			returnValue = getOutputSignal();
		}
		setDetails(returnValue.toString());
		return new JudgmentResult(line.getLast().getTag(),returnValue);
	}
	
}
