/**
 * Copyright (C) 2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneListException;

/**
 * JEg_EVOio̓ubN<br>
 * ̓VOi""""ɂȂɃJEg_EJn
 * JEg_EIAw肵VOio͂܂B
 * 
 * @since 2.10
 * @author Copyright (C) 2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeSignalBlock
@EnabledDefaultSignal
@EnabledOutputSignal
@GeneDefaultLabelList(values={"count"})
// uany@v͂łڑ\ȂƂӖ
@InputComponentList(values={"any@Signal"})
public class CountDownSignalBlock extends EventSignalBlock {

	/**
	 * JEgB̓f[^̐ŎwB
	 * 
	 * @since 2.10
	 */
	private final int m_initialCount;

	/**
	 * JEg
	 * 
	 * @since 2.10
	 */
	private int m_currentCount;

	/**
	 * JEg_EJnVOi
	 * 
	 * @since 2.30
	 */
	private NmSignal m_triggerSignal;
	
	/**
	 * Oo͂VOi
	 * 
	 * @since 2.30
	 */
	private JudgmentResult m_prevSignal;
	
	/**
	 * JEg_EǂtO
	 * 
	 * @since 2.31
	 */
	private boolean m_active;

	/**
	 * CountDownSignalBlock𐶐܂B
	 * 
	 * @since 2.30
	 * @param p_label x
	 * @param p_priority Dx
	 * @param p_outputSignal ɏo͂VOi
	 * @param p_geneList p[^Xg
	 * @param p_countLabel JEg̃p[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public CountDownSignalBlock(String p_label, int p_priority, NmSignal p_outputSignal, GeneList p_geneList,
			String p_countLabel) throws GeneListException {
		super(p_label, p_priority, p_outputSignal);
		m_initialCount = p_geneList.getGene(p_countLabel).getIntValue();
		m_triggerSignal = NmSignal.NOSIGNAL;
		m_active = false;
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.SignalBlock#getJudgmentResult()
	 */
	@Override
	public JudgmentResult getJudgmentResult() throws IndexStreamException {
		Tag inputTag = getInputTag();
		if (inputTag==null) return new JudgmentResult(null,NmSignal.NOSIGNAL);
		if (m_prevSignal!=null && inputTag.equals(m_prevSignal.getTag())) return m_prevSignal;
		JudgmentResult returnValue = new JudgmentResult(inputTag,NmSignal.NOSIGNAL);
		JudgmentResult inputSignal = super.getJudgmentResult();
		if (m_active) {
			// JEg_EJnĂ
			if ((m_triggerSignal==NmSignal.LONG && inputSignal.getSignal()==NmSignal.SHORT) ||
				(m_triggerSignal==NmSignal.SHORT && inputSignal.getSignal()==NmSignal.LONG)) {
				// JEg_Eɔ΃VOiꍇ̓he
				m_currentCount = m_initialCount;
				m_triggerSignal = inputSignal.getSignal();
			} else	if (inputSignal.getSignal()==NmSignal.ESCAPE) {
				// JEg_EɑޏoVOiJEg_EI
				m_currentCount = 0;
				returnValue = new JudgmentResult(inputTag, getOutputSignal());
			} else {
				// JEg_E
				if (m_currentCount>0) --m_currentCount;
				if (m_currentCount<=0) {
					m_currentCount = 0;
					returnValue = new JudgmentResult(inputTag, getOutputSignal());
				}
			}
		} else {
			// JEg_EJnĂȂ
			if (inputSignal.getSignal()==NmSignal.LONG || inputSignal.getSignal()==NmSignal.SHORT) {
				// VOioJEg_EJn
				m_active = true;
				m_currentCount = m_initialCount;
				m_triggerSignal = inputSignal.getSignal();
			}
		}
		m_prevSignal = returnValue;
		setDetails(returnValue.getSignal().toString() + "(count=" + m_currentCount + ")");
		return returnValue;
	}
	
}
