/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

/**
 * jp.robotbrain.signalpbP[W̋ʃ[eBeB
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class UtilSignal {

	/**
	 * [eBeBNX̂߃RXgN^͌J܂B
	 * 
	 * @since 1.00
	 */
	private UtilSignal() {
	}
	
	/**
	 * \[XCׂĂ̗vf̕ϒlvZ܂B
	 * 
	 * @since 1.00
	 * @param p_src \[XC
	 * @return ϒl
	 */
	public static double calcAvg(IndexLine p_src) {
		double sum = 0.0;
		for (int i = 0; i < p_src.size(); i++) {
			sum += p_src.get(i).getValue();
		}
		if (p_src.size()==0) return 0;
		return sum / p_src.size();
	}

	/**
	 * \[XCׂĂ̗vf̕W΍vZ܂B
	 * 
	 * @since 1.00
	 * @param p_src \[XC
	 * @return W΍
	 */
	public static double calcStdev(IndexLine p_src) {
		double sum = 0.0;
		double avg = calcAvg(p_src);
		for (int i = 0; i < p_src.size(); i++) {
			double v = p_src.get(i).getValue();
			sum += (v - avg) * (v - avg);
		}
		if (p_src.size()==0) return 0;
		return Math.sqrt(sum / p_src.size());
	}
	
	/**
	 * TR(TrueRange)vZ܂B
	 * 
	 * @since 1.00
	 * @param p_prevCandleStick PÕ[\N
	 * @param p_currentCandleStick Jg̃[\N
	 * @return TR(TrueRange)
	 */
	public static double calcTrueRange(CandleStick p_prevCandleStick, CandleStick p_currentCandleStick) {
		/*
		 ̍l|̈l (A)
		 ̍l|ȌIl (B)
		 ȌIl|̈l (C)
		 */
		double trA = p_currentCandleStick.getHigh() - p_currentCandleStick.getLow();
		double trB = p_currentCandleStick.getHigh() - p_prevCandleStick.getClose();
		double trC = p_prevCandleStick.getClose() - p_currentCandleStick.getLow();
		
		double trMax = 0;
		if (trA > trB) {
			if (trA < trC) {
				trMax = trC;
			} else {
				trMax = trA;
			}
		} else {
			if (trB < trC) {
				trMax = trC;
			} else {
				trMax = trB;
			}
		}
		return trMax;
	}

}
