/**
 * Copyright (C) 2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ConcurrentHashMap;

/**
 * [\N^C~O^Ce[u
 * 
 * @since 2.00
 * @author Copyright (C) 2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class CandleStickTimeTable {

	/**
	 * ^Ce[u
	 * 
	 * @since 2.00
	 */
	private ConcurrentHashMap<String,Integer> m_timetable;

	/**
	 * CandleStickTimeTable𐶐܂B
	 * 
	 * @since 2.00
	 * @param p_minute ̃^Ce[u𐶐邩w肵܂BႦ10Ȃ10n܂B
	 * @throws IndexStreamException [\N^C~O^Ce[ut@C̃ANZXɎsꍇ
	 */
	public CandleStickTimeTable(int p_minute) throws IndexStreamException {
		try {
			InputStream istream = getClass().getResourceAsStream("cstable/" + p_minute + ".txt");
			if (istream==null) {
				throw new IndexStreamException("Candlestick TimeTable Not Found: minute=" + p_minute);
			}
			BufferedReader br = new BufferedReader(new InputStreamReader(istream));
			m_timetable = new ConcurrentHashMap<String,Integer>();
			while (br.ready()) {
				String line = br.readLine();
				String[] cols = line.split(",");
				if (cols.length!=2) 
					throw new IndexStreamException("Candlestick TimeTable Format Error: col=" + cols.length);
				m_timetable.put(cols[0], Integer.parseInt(cols[1]));
			}
			br.close();
		} catch (FileNotFoundException e) {
			throw new IndexStreamException("Candlestick TimeTable FileNotFoundException: " + e.getMessage());
		} catch (IOException e) {
			throw new IndexStreamException("Candlestick TimeTable IOException: " + e.getMessage());
		}
	}
	
	/**
	 * w肵̃GAԂ܂B
	 * 
	 * @since 2.00
	 * @param p_time 
	 * @return GA
	 */
	public int lookup(String p_time) {
		return  m_timetable.get(p_time);
	}
	
}
