/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.framework.Gene;
import jp.robotbrain.framework.GeneList;
import jp.robotbrain.framework.GeneDefaultLabelList;
import jp.robotbrain.framework.GeneListException;
import jp.robotbrain.signal.BollingerBandList;
import jp.robotbrain.signal.IndexLine;
import jp.robotbrain.signal.IndexObjectList;

/**
 * {W[ohXgXg[
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("BollingerBandList")
@InputComponentList(values={"@IndexLine"})
@GeneDefaultLabelList(values={"pcountCenter","pcountStdev","sigmaHigh","sigmaLow"})
public class BollingerBandListStream extends IndexStream {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * {W[oh̃Xg
	 * 
	 * @since 1.00
	 */
	private final BollingerBandList m_bollingerBandList;
	
	/**
	 * BollingerBandListStream𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 * @param p_geneList p[^Xg
	 * @param p_pcountCenterLabel Z^[C(Pړ)Zô߂Ɏg|Cg̃p[^x
	 * @param p_pcountStdevLabel W΍Zô߂Ɏg|Cg̃p[^x
	 * @param p_sigmaHighLabel ̃Ђ̃p[^x
	 * @param p_sigmaLowLabel ̃Ђ̃p[^x
	 * @throws GeneListException ݂Ȃp[^xw肵ꍇ
	 */
	public BollingerBandListStream(String p_label, GeneList p_geneList, String p_pcountCenterLabel, 
			String p_pcountStdevLabel, String p_sigmaHighLabel, String p_sigmaLowLabel) throws GeneListException {
		super(p_label);
		// p[^̎擾
		Gene pcountCenterGene = p_geneList.getGene(p_pcountCenterLabel);
		Gene pcountStdevGene = p_geneList.getGene(p_pcountStdevLabel);
		Gene sigmaHighGene = p_geneList.getGene(p_sigmaHighLabel);
		Gene sigmaLowGene = p_geneList.getGene(p_sigmaLowLabel);
		// {W[oh̐
		int pcountCenter = pcountCenterGene.getIntValue();
		int pcountStdev = pcountStdevGene.getIntValue();
		double sigmaHigh = sigmaHighGene.getDoubleValue();
		double sigmaLow = sigmaLowGene.getDoubleValue();
		m_bollingerBandList = new BollingerBandList(pcountCenter,pcountStdev,sigmaHigh,sigmaLow);
	}
	
	/**
	 * Xg[̓
	 * 
	 * @since 1.00
	 * @param p_src \[XC
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	public void enter(IndexLine p_src) throws IndexStreamException {
		notifyIndex(p_src);
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#notifyIndex(jp.robotbrain.signal.IndexObjectList)
	 */
	@Override
	public void notifyIndex(IndexObjectList<?> p_indexObjectList)
		throws IndexStreamException {
		// null`FbN
		if (p_indexObjectList==null) {
			throw new IndexStreamException("Null Error");
		}
		// CX^X`FbN
		if (!(p_indexObjectList instanceof IndexLine)) {
			throw new IndexStreamException("Instance Error");
		}
		// TCY`FbN
		if (p_indexObjectList.size()<=0) {
			return;
		}
		// IuWFNg̒ǉ
		int prevSize = m_bollingerBandList.size();
		m_bollingerBandList.addObject((IndexLine)p_indexObjectList);
		// ̃eNjJwWɒʒm
		if (m_bollingerBandList.size()>prevSize)
			notifyIndexNext(m_bollingerBandList);
	}

	/**
	 * {W[oh̃XgԂ܂B
	 * 
	 * @since 1.00
	 * @return {W[oh̃Xg
	 */
	@Override
	public BollingerBandList getValues() {
		return m_bollingerBandList;
	}
	
}
