/**
 * Copyright (C) 2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.LogManager;
import java.util.logging.Logger;

/**
 * t@CtH_ɃANZX鋤ʃ[eBeB
 * 
 * @since 2.05
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class UtilFile {

	/**
	 * [eBeBNX̂߃RXgN^͌J܂B
	 * 
	 * @since 2.05
	 */
	private UtilFile() {
	}
	
	/**
	 * K[
	 * 
	 * @since 2.05
	 */
	static private Logger m_logger = null;

	/**
	 * K[Ԃ܂
	 * 
	 * @since 2.05
	 * @return K[
	 */
	static public Logger getLogger() {
		return m_logger;
	}

	/**
	 * K[܂B
	 * 
	 * @since 2.05
	 * @param p_logLocation Oo̓tH_inr̃[UtH_̑Έʒuj
	 * @param p_logLevel Ox
	 * @throws IOException K[̏Ɏsꍇ
	 */
	synchronized static public void initLogger(String p_logLocation, String p_logLevel) throws IOException {
		if (m_logger!=null) return;
	    InputStream configLogStream = null;
        configLogStream = new ByteArrayInputStream(createLogConfig(p_logLocation, p_logLevel).getBytes("UTF-8"));
        LogManager.getLogManager().readConfiguration(configLogStream);
        if (configLogStream != null) {
        	configLogStream.close();
        	m_logger = Logger.getLogger("jp.robotbrain");
        }
	}
	
	/**
	 * K[̐B
	 * 
	 * @since 2.05
	 * @param p_logLocation Oo͏ꏊB[UtH_̑ΈʒuB
	 * @param p_logLevel Ox
	 * @return K[
	 */
	static private String createLogConfig(String p_logLocation, String p_logLevel) {
		String returnValue = 
			"handlers=java.util.logging.ConsoleHandler,java.util.logging.FileHandler\n" +
		    ".level=" + p_logLevel + "\n" +
		    "java.util.logging.ConsoleHandler.level=" + p_logLevel + "\n" +
		    "java.util.logging.ConsoleHandler.formatter=java.util.logging.SimpleFormatter\n" + 
		    "java.util.logging.FileHandler.level=" + p_logLevel + "\n" + 
		    "java.util.logging.FileHandler.pattern=%h" + p_logLocation + "robotlog_%u\n" + 
		    "java.util.logging.FileHandler.formatter=java.util.logging.SimpleFormatter\n" + 
	    	"java.util.logging.FileHandler.count=10\n";
		return returnValue;
	}
	
	/**
	 * G[HTMLt@Cɏo͂܂
	 * 
	 * @since 2.05
	 * @param p_folderPath o͐tH_̃pX
	 * @param p_html HTML̓e
	 * @return HTMLt@C̃pXBo͂Ɏs""Ԃ܂B
	 */
	static public String writeErrorHtml(String p_folderPath, String p_html) {
		Date date = new Date();
		SimpleDateFormat formatter;
		formatter = new SimpleDateFormat("yyyyMMddHHmmssSSSS");
		String filePath = p_folderPath + formatter.format(date) + ".html";
		try {
			File dest = new File(filePath);
			FileOutputStream fos = new FileOutputStream(dest,true); 
			OutputStreamWriter osw = new OutputStreamWriter(fos,"SJIS");
			BufferedWriter bw = new BufferedWriter(osw);
			bw.write(p_html);
			bw.newLine();
			bw.close();
		} catch (IOException e) {
			e.printStackTrace();
			return "";
		}
		return filePath;
	}

	/**
	 * t@C폜܂
	 * 
	 * @since 2.05
	 * @param p_filePath 폜t@C
	 */
	static public void delete(String p_filePath) {
		File f = new File(p_filePath);
		f.delete();
	}
	
	/**
	 * tH_Rs[܂BKw̃tH_At@CׂăRs[܂B
	 * 
	 * @since 2.05
	 * @param p_src Rs[tH_̃pX
	 * @param p_dest Rs[tH_̃pX
	 * @return ɐtrueԂ܂
	 * @throws IOException tH_At@C̃Rs[Ɏsꍇ
	 */
	static public boolean copyFolder(String p_src, String p_dest) throws IOException{
		return copyFolder(new File(p_src), new File(p_dest));
	}

	/**
	 * t@CRs[܂
	 * 
	 * @since 2.05
	 * @param p_src Rs[t@C̃pX
	 * @param p_dest Rs[t@C̃pX
	 * @return ɐtrueԂ܂
	 * @throws IOException t@C̃Rs[Ɏsꍇ
	 */
	static public boolean copyFile(String p_src, String p_dest) throws IOException{
		return copyFile(new File(p_src), new File(p_dest));
	}
	
	/**
	 * tH_At@CRs[܂iċApj
	 * 
	 * @since 2.05
	 * @param p_src Rs[tH_At@C
	 * @param p_dest Rs[tH_At@C
	 * @return ɐtrueԂ܂
	 * @throws IOException tH_At@C̃Rs[Ɏsꍇ
	 */
	static private boolean copyFolder(File p_src, File p_dest) throws IOException{
		if(!p_src.exists() || !p_src.isDirectory())return false;
		p_dest.mkdirs();
		File[] files = p_src.listFiles();
		for(int i = 0; files.length>i; i++){
			if(files[i].isDirectory()){
				copyFolder(
						new File(p_src.toString(), files[i].getName()), 
						new File(p_dest.toString(), files[i].getName()));
			}else{
				copyFile(
						new File(p_src.toString(), files[i].getName()), 
						new File(p_dest.toString(), files[i].getName()));			
			}			
		}
		return true;
	}
	
	/**
	 * t@CRs[܂
	 * 
	 * @since 2.05
	 * @param p_src Rs[t@C
	 * @param p_dest Rs[t@C
	 * @return ɐtrueԂ܂
	 * @throws IOException t@C̃Rs[Ɏsꍇ
	 */
	static private boolean copyFile(File p_src, File p_dest) throws IOException {
		if(!p_src.exists())return false;
		byte[] buf = new byte[1024];
		int readByte;
		BufferedInputStream inputStream = 
			new BufferedInputStream(new FileInputStream(p_src));
		BufferedOutputStream outputStream = 
			new BufferedOutputStream(new FileOutputStream(p_dest));
		while((readByte=inputStream.read(buf,0,buf.length)) != -1){
			outputStream.write(buf, 0, readByte);
		}
		outputStream.close();
		inputStream.close();
		return true;
	}

	/**
	 * tH_쐬܂BetH_܂߂č쐬܂B
	 * 
	 * @since 2.05
	 * @param p_path tH_̃pX
	 * @return ɐtrueԂ܂
	 */
	public static boolean createFolders(String p_path) {
		File f = new File(p_path);
		if (!f.exists()) {
			return f.mkdirs();
		}
		return true;
	}

	/**
	 * t@CtH_݂̑mF܂B
	 * 
	 * @since 2.05
	 * @param p_path t@CtH_̃pX
	 * @return t@CtH_݂ꍇtrueԂ܂
	 */
	public static boolean isExists(String p_path) {
	    File f = new File(p_path);
	    if(f.exists() ){
	        return true;
	    } else {
	    	return false;
	    }
	}	
	
}
