/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import jp.robotbrain.signal.CandleStickList;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.TrueRangeLine;

/**
 * TRCXg[
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeIndexStream("TrueRangeLine")
@InputComponentList(values={"@CandleStickList"})
public class TrueRangeLineStream extends IndexStream {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * TRC
	 * 
	 * @since 1.00
	 */
	private final TrueRangeLine m_trueRangeLine;
	
	/**
	 * TrueRangeLineStream𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 */
	public TrueRangeLineStream(String p_label) throws IndexStreamException {
		super(p_label);
		// TRC̐
		m_trueRangeLine = new TrueRangeLine();
	}
	
	/**
	 * Xg[̓
	 * 
	 * @since 1.00
	 * @param p_src \[X[\NXg
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	public void enter(CandleStickList p_src) throws IndexStreamException {
		notifyIndex(p_src);
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexStream#notifyIndex(jp.robotbrain.signal.IndexObjectList)
	 */
	@Override
	public void notifyIndex(IndexObjectList<?> p_indexObjectList)
			throws IndexStreamException {
		// null`FbN
		if (p_indexObjectList==null) {
			throw new IndexStreamException("Null Error");
		}
		// CX^X`FbN
		if (!(p_indexObjectList instanceof CandleStickList)) {
			throw new IndexStreamException("Instance Error");
		}
		// TCY`FbN
		if (p_indexObjectList.size()<=0) {
			return;
		}
		// |Cgǉ
		int prevSize = m_trueRangeLine.size();
		m_trueRangeLine.addPoint((CandleStickList)p_indexObjectList);
		// ̃eNjJwWɒʒm
		if (m_trueRangeLine.size()>prevSize)
			notifyIndexNext(m_trueRangeLine);
	}

	/**
	 * TRCԂ܂B
	 * 
	 * @since 1.00
	 * @return TRC
	 */
	@Override
	public TrueRangeLine getValues() {
		return m_trueRangeLine;
	}

}
