/**
 * Copyright (C) 2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

/**
 * t@XgCX[C̏ɂꍇɔVOio͂܂B
 * ȊO̓ftHgVOio͂܂B
 * ܂A܂΍Ƃăt@XgCƃX[C̘w肵
 * ̎w肵l傫ȘɂȂꍇɃVOio͂邱Ƃł܂B
 * 
 * @since 2.00
 * @author Copyright (C) 2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeSignalStream
@EnabledDefaultSignal
@InputComponentList(values={"slow@IndexLine","fast@IndexLine","*difference@IndexLine"})
public class CrossOverLongSignal extends CrossSignal {

	/**
	 * CrossOverLongSignal𐶐܂B
	 * 
	 * @since 2.00
	 * @param p_label x
	 * @param p_priority Dx
	 */
	public CrossOverLongSignal(String p_label, int p_priority) {
		super(p_label, p_priority);
		getPortList().add("slow@IndexLine");
		getPortList().add("fast@IndexLine");
		getPortList().add("*difference@IndexLine");
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.CrossSignal#getJudgmentResult()
	 */
	@Override
	public JudgmentResult getJudgmentResult() throws IndexStreamException {
		IndexStreamPort slow = getPortList().get("slow@IndexLine");
		IndexStreamPort fast = getPortList().get("fast@IndexLine");
		IndexStreamPort difference = getPortList().get("*difference@IndexLine");
		// portnull`FbN
		if (slow==null)
			throw new IndexStreamException("slow@IndexLine Port Null Error");
		if (fast==null)
			throw new IndexStreamException("fast@IndexLine Port Null Error");
		if (difference==null)
			throw new IndexStreamException("*difference@IndexLine Port Null Error");
		// Xgnull`FbN
		if (slow.getObjectList()==null) return new JudgmentResult(null,NmSignal.NOSIGNAL);
		if (fast.getObjectList()==null) return new JudgmentResult(null,NmSignal.NOSIGNAL);
		// CX^X`FbN
		if (!(slow.getObjectList() instanceof IndexLine))
			throw new IndexStreamException("slow@IndexLine Instance Error");
		if (!(fast.getObjectList() instanceof IndexLine))
			throw new IndexStreamException("fast@IndexLine Instance Error");
		// TCY`FbN
		IndexLine slowLine = (IndexLine)slow.getObjectList();
		if (slowLine.size()<1) {
			setDetails(NmSignal.NOSIGNAL.toString());
			return new JudgmentResult(null,NmSignal.NOSIGNAL);
		}
		IndexLine fastLine = (IndexLine)fast.getObjectList();
		if (fastLine.size()<1) {
			setDetails(NmSignal.NOSIGNAL.toString());
			return new JudgmentResult(null,NmSignal.NOSIGNAL);
		}
		// σ|[g`FbN
		IndexLine differenceLine = null;
		if (difference.getObjectList()!=null) {
			// CX^X`FbN
			if (!(difference.getObjectList() instanceof IndexLine))
				throw new IndexStreamException("*difference@IndexLine Instance Error");
			// TCY`FbN
			differenceLine = (IndexLine)difference.getObjectList();
			if (differenceLine.size()<1) {
				setDetails(NmSignal.NOSIGNAL.toString());
				return new JudgmentResult(null,NmSignal.NOSIGNAL);
			}
		}
		// VOi
		NmSignal returnValue = getDefaultSignal();
		double fastValue = fastLine.getLast().getValue();
		double slowValue = slowLine.getLast().getValue();
		double differenceValue = 0;
		if (differenceLine!=null) {
			differenceValue = differenceLine.getLast().getValue();
		}
		if (isCrossOver(fastValue, slowValue, differenceValue)) returnValue = NmSignal.LONG;
		setDetails("[" + getLabel() + "]" + returnValue.toString());
		return new JudgmentResult(fastLine.getLast().getTag(),returnValue);
	}
	
}
