/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.net;

import java.io.*;
import java.net.*;

import jp.robotbrain.html.HtmlForm;
import jp.robotbrain.html.HtmlFormException;

/**
 * WebʐM(http,https)sNX
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class Web {

	/**
	 * URL
	 * 
	 * @since 1.00
	 */
	private URL m_url;

	/**
	 * httpRlNV
	 * 
	 * @since 1.00
	 */
	private HttpURLConnection m_connection;

	/**
	 * http_CNg(R[h3xx̗v)邩Ȃ
	 * 
	 * @since 1.00
	 */
	private boolean m_autoRedirects;
	
	/**
	 * s؂蕶
	 * 
	 * @since 1.00
	 */
	private String m_lineSeparator = System.getProperty("line.separator");

	/**
	 * httpʐMŎ擾CookiẽXg
	 * 
	 * @since 1.10
	 */
	private CookieList m_cookieList;
	
	/**
	 * httpwb_[Xg
	 * 
	 * @since 1.12
	 */
	private HttpHeaderList m_httpHeaderList;
	
	/**
	 * WebʐMCX^X𐶐܂BCX^XɒOɃANZXURLێ
	 * Refererwb_[𐶐ACookie̕ێƑMs܂̂ŁÄقȂTCg
	 * ƒʐMꍇ̓TCgɃCX^X𐶐ĂB
	 *  
	 * @since 1.00
	 */
	public Web() {
		m_autoRedirects = false;
		m_cookieList = new CookieList();
		m_httpHeaderList = new HttpHeaderList();
	}
	
	/**
	 * GEThtml̃eLXgf[^Ԃ܂B
	 * 
	 * @since 1.00
	 * @param p_URL URL
	 * @param p_charset 擾html̕Zbg
	 * @param p_httpHeaderList httpwb_[̃Xg
	 * @return X|Xhtml
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">Zbg</a>
	 * @throws HttpSendException NGXgMɎsꍇ
	 * @throws HttpRecvException X|XMɎsꍇ
	 * @throws CookieException Cookie͂Ɏsꍇ
	 */
	public String getHtml(String p_URL, String p_charset, 
			HttpHeaderList p_httpHeaderList) throws HttpSendException, HttpRecvException, CookieException {
		// NbL[t
		HttpHeaderList reqHeader = new HttpHeaderList();
		if (p_httpHeaderList!=null) reqHeader.addList(p_httpHeaderList);
		HttpHeader cookieHeader = m_cookieList.createRequestCookie(p_URL, p_charset);
		if (cookieHeader!=null) reqHeader.add(cookieHeader);
		// NGXgM
		try {
			setURL(p_URL);
			if (reqHeader!=null) setRequestProperties(reqHeader);
			doGet();
			if (getStatusCode() >= 400) {
				throw new IOException("getHtml HttpError HttpStatusCode=" + getStatusCode());
			}
		} catch (IOException e) {
			e.printStackTrace();
			throw new HttpSendException("getHtml SendError URL="+p_URL+" :"+e.getMessage());
		}	
		// X|XM
		String returnValue = "";
		try {
			returnValue = getResponseText(p_charset);
		} catch (IOException e) {
			e.printStackTrace();
			throw new HttpRecvException("getHtml RecvError URL="+p_URL+" :"+e.getMessage());
		}
		importResponseCookie();
		return returnValue;
	}

	/**
	 * GEThtmlInputStreamԂ܂B
	 * 
	 * @since 1.00
	 * @param p_URL URL
	 * @param p_charset 擾html̕Zbg
	 * @param p_httpHeaderList httpwb_[̃Xg
	 * @return X|XhtmlInputStream
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">Zbg</a>
	 * @throws IOException ɎsꍇBڍ׃bZ[WhttpXe[^XR[hB
	 */
	public InputStream getHtmlStream(String p_URL, String p_charset, 
			HttpHeaderList p_httpHeaderList) throws IOException {
		setURL(p_URL);
		if (p_httpHeaderList!=null) setRequestProperties(p_httpHeaderList);
		doGet();
		if (getStatusCode() >= 400) {
			throw new IOException("HttpStatusCode=" + getStatusCode());
		}	
		return getResponseStream();
	}
	
	/**
	 * POSThtml̃eLXgf[^Ԃ܂B
	 * 
	 * @since 1.00
	 * @param p_URL URL
	 * @param p_queryString NG
	 * @param p_charset 擾html̕Zbg
	 * @param p_httpHeaderList httpwb_[̃Xg
	 * @return X|Xhtml
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">Zbg</a>
	 * @throws HttpSendException NGXgMɎsꍇ
	 * @throws HttpRecvException X|XMɎsꍇ
	 * @throws CookieException Cookie͂Ɏsꍇ
	 */
	public String postHtml(String p_URL, String p_queryString, String p_charset,
			HttpHeaderList p_httpHeaderList) throws HttpSendException, HttpRecvException, CookieException {
		// NbL[t
		HttpHeaderList reqHeader = new HttpHeaderList();
		if (p_httpHeaderList!=null) reqHeader.addList(p_httpHeaderList);
		HttpHeader cookieHeader = m_cookieList.createRequestCookie(p_URL, p_charset);
		if (cookieHeader!=null) reqHeader.add(cookieHeader);
		// NGXgM
		try {
			setURL(p_URL);
			if (reqHeader!=null) setRequestProperties(reqHeader);
			doPost(p_queryString);
			if (getStatusCode() >= 400) {
				throw new HttpSendException("postHtml HttpError URL="+p_URL+" QueryString="+p_queryString+ 
						" HttpStatusCode=" + getStatusCode());
			}
		} catch (IOException e) {
			e.printStackTrace();
			throw new HttpSendException("postHtml SendError URL="+p_URL+" QueryString="+p_queryString+
					" :"+e.getMessage());
		}
		// X|XM
		String returnValue = "";
		try {
			returnValue = getResponseText(p_charset);
		} catch (IOException e) {
			e.printStackTrace();
			throw new HttpRecvException("postHtml RecvError URL="+p_URL+" QueryString="+p_queryString+
					" :"+e.getMessage());
		}
		importResponseCookie();
		return returnValue;
	}
	
	/**
	 * GETĉ摜̃oCif[^Ԃ܂B
	 * 
	 * @since 1.00
	 * @param p_URL URL
	 * @param p_httpHeaderList httpwb_[̃Xg
	 * @return 摜̃oCif[^
	 * @throws HttpSendException NGXgMɎsꍇ
	 * @throws HttpRecvException X|XMɎsꍇ
	 */
	public byte[] getImage(String p_URL, HttpHeaderList p_httpHeaderList)
			throws HttpSendException, HttpRecvException {
		// NGXgM
		try {
			setURL(p_URL);
			if (p_httpHeaderList!=null) setRequestProperties(p_httpHeaderList);
			doGet();
			if (getStatusCode() != 200) {
				throw new IOException("HttpStatusCode=" + getStatusCode());
			}
		} catch (IOException e) {
			e.printStackTrace();
			throw new HttpSendException(e.getMessage());
		}
		// X|XM
		byte[] returnValue;
		try {
			returnValue = getResponseBinary();
		} catch (IOException e) {
			e.printStackTrace();
			throw new HttpRecvException(e.getMessage());
		}
		return returnValue;
	}
	
	/**
	 * URLZbg܂B
	 * 
	 * @since 1.00
	 * @param p_URL URL
	 * @throws IOException T[o[Ƃ̒ʐMŃG[ꍇ
	 */
	private void setURL(String p_URL) throws IOException {
		// URL IuWFNg̐
		m_url = new URL(p_URL);
		// HttpURLConnectionIuWFNg̐
		m_connection = (HttpURLConnection) m_url.openConnection();
		// _CNg̎ݒ
		if (!m_autoRedirects) {
			m_connection.setInstanceFollowRedirects(false);
		}
	}

	/**
	 * GETNGXg𔭍s܂B
	 * 
	 * @since 1.00
	 * @throws IOException T[o[Ƃ̒ʐMŃG[ꍇ
	 */
	private void doGet() throws IOException {
		// NGXg\bh
		m_connection.setRequestMethod("GET");
		// ڑENGXgsiSYN,SYN/ACK,ACK̒ʐMj
		m_connection.connect();
	}

	/**
	 * httpwb_[̃XgZbg܂B
	 * 
	 * @since 1.00
	 * @param p_httpHeaderList httpwb_[̃Xg
	 */
	private void setRequestProperties(HttpHeaderList p_httpHeaderList) {
		for (int i = 0; i < p_httpHeaderList.size(); i++) {
			HttpHeader hd = p_httpHeaderList.get(i);
			m_connection.setRequestProperty(hd.getName(), hd.getValue());
		}
	}

	/**
	 * POSTNGXg𔭍s܂B
	 * 
	 * @since 1.00
	 * @param p_queryString NG
	 * @throws IOException T[o[Ƃ̒ʐMŃG[ꍇ
	 */
	private void doPost(String p_queryString) throws IOException {
		// NGXg\bh
		m_connection.setRequestMethod("POST");
		// bZ[Wꍇ
		setRequestMessage(p_queryString);
		// ڑENGXgs
		m_connection.connect();
	}

	/**
	 * NGXgbZ[Wݒ肵܂BiPOSTɎgpj
	 * 
	 * @since 1.00
	 * @param p_queryString NG
	 * @throws IOException NGXgbZ[W̐ݒɎsꍇ
	 */
	private void setRequestMessage(String p_queryString) throws IOException {
		// NGXg{fB𓊂悤ɂ
		m_connection.setDoOutput(true);
		// NGXg{fBMIME application/x-www-form-urlencoded
		m_connection.setRequestProperty("Content-Type",
				"application/x-www-form-urlencoded");
		// NGXg{fB̒
		m_connection.setRequestProperty("Content-Length", Integer.toString(p_queryString
				.length()));
		// NGXgbZ[W𗬂ޏo̓Xg[
		BufferedWriter outer = new BufferedWriter(new OutputStreamWriter(m_connection
				.getOutputStream()));
		outer.write(p_queryString);
		outer.flush();
		outer.close();
	}

	/**
	 * httpXe[^XR[hԂ܂B
	 * xNGXgĂȂꍇ-1Ԃ܂B
	 * 
	 * @since 1.00
	 * @return Xe[^XR[h
	 * @throws IOException  httpXe[^XR[h̎擾Ɏsꍇ
	 */
	public int getStatusCode() throws IOException {
		if (m_connection==null) return -1;
		// GET/POSTNGXg𔭍sĂ
		return m_connection.getResponseCode();
	}

	/**
	 * e탊NGXg\bhœX|Xwb_[Wo͂܂B
	 * 
	 * @since 1.00
	 * @throws IOException httpwb_[̎擾Ɏsꍇ
	 */
	public void printHttpHeaderList() throws IOException {
		if (m_connection==null) return;		
		int i = 0;
		String name = "";
		String value = "";
		while (true) {
			++i;
			name = m_connection.getHeaderFieldKey(i);
			value = m_connection.getHeaderField(i);
			if (value==null) break;
			System.out.println(name + ":" + value);
		}
	}

	/**
	 * X|Xwb_[Ɋ܂܂NbL[荞݂܂B
	 * @throws CookieException Cookie͂Ɏsꍇ
	 * 
	 * @since 1.10
	 */
	private void importResponseCookie() throws CookieException {
		if (m_connection==null) return;		
		int i = 0;
		while (true) {
			String name = m_connection.getHeaderFieldKey(i);
			String value = m_connection.getHeaderField(i);
			if (value==null) break;
			if (name!=null) {
				if (name.equalsIgnoreCase("Set-Cookie")) {
					m_cookieList.importResponseCookie(getURL(),value);
				}
			}
			i++;
		}
	}
	
	/**
	 * NGXgpCookie𐶐ĕԂ܂B
	 * xNGXgĂȂꍇnullԂ܂B
	 * CookieM̎ɔp~
	 * 
	 * @since 1.00
	 * @return NGXgpCookie
	 */
	@Deprecated
	public HttpHeader createCookie() {
		if (m_connection==null) return null;
		HttpHeaderList cookies = getCookieList();
		String value = extractCookieString(cookies);
		return new HttpHeader("Cookie",value);
	}

	/**
	 * e탊NGXg\bhœX|Xwb_[Ɋ܂܂
	 * NbL[̃XgԂ܂B
	 * CookieM̎ɔp~
	 * 
	 * @since 1.00
	 * @return NbL[({@link HttpHeader HttpHeader})ArrayList
	 */
	@Deprecated
	private HttpHeaderList getCookieList() {
		if (m_connection==null) return null;		
		int i = 0;
		HttpHeaderList returnValue = new HttpHeaderList();
		while (true) {
			String name = m_connection.getHeaderFieldKey(i);
			String value = m_connection.getHeaderField(i);
			if (value==null) break;
			if (name!=null) {
				if (name.equals("Set-Cookie")) {
					returnValue.add(new HttpHeader(name,value));
				}
			}
			i++;
		}
		return returnValue;
	}

	/**
	 * X|Xwb_[̃NbL[XgNbL[(name=value)𔲂o܂B
	 * CookieM̎ɔp~
	 * 
	 * @since 1.00
	 * @param p_cookieList X|Xwb_[̃NbL[Xg
	 * @return NbL[(name=value)̕
	 */
	@Deprecated
	private String extractCookieString(HttpHeaderList p_cookieList) {
		String returnValue = "";
		for (int i=0;i<p_cookieList.size();i++) {
			HttpHeader cookie = p_cookieList.get(i);
			int delimit = cookie.getValue().indexOf(";");
			returnValue += cookie.getValue().substring(0, delimit) + ";";
		}
		return returnValue;
	}

	/**
	 * X|Xwb_[̒lԂ܂B
	 * xNGXgĂȂꍇ͋󕶎""Ԃ܂B
	 * 
	 * @since 1.00
	 * @param p_name X|Xwb_[̖O
	 * @return X|Xwb_[̒l
	 */
	public String getResponseHeaderValue(String p_name) {
		if (m_connection==null) return "";		
		int i = 0;
		while (true) {
			String name = m_connection.getHeaderFieldKey(i);
			String value = m_connection.getHeaderField(i);
			if (value==null) break;
			if (name!=null) {
				if (name.equals(p_name)) {
					return value;
				}
			}
			i++;
		}
		return "";
	}

	
	/**
	 * X|X󂯎邽߂̃Xg[Ԃ܂B
	 * 
	 * @since 1.00
	 * @return X|X󂯎邽߂̃Xg[
	 * @throws IOException T[o[Ƃ̒ʐMŃG[ꍇ
	 */
	private InputStream getResponseStream() throws IOException {
		return m_connection.getInputStream();
	}

	/**
	 * X|X{fBeLXgƂĕԂ܂B
	 * 
	 * @since 1.00
	 * @param p_charCode Zbg
	 * @return X|X{fB̕
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">Zbg</a>
	 * @throws IOException T[o[Ƃ̒ʐMŃG[ꍇ
	 */
	private String getResponseText(String p_charCode) throws IOException {
		BufferedReader inner = new BufferedReader(new InputStreamReader(
				getResponseStream(), p_charCode));
		String response = "";
		String line = "";
		while ((line = inner.readLine()) != null) {
			response += line + m_lineSeparator;
		}
		inner.close();
		return response;
	}

	/**
	 * X|X{fBoCiƂĕԂ܂B
	 * 
	 * @since 1.00
	 * @return X|X{fB̃oCif[^
	 * @throws IOException T[o[Ƃ̒ʐMŃG[ꍇ
	 */
	private byte[] getResponseBinary() throws IOException {
		byte[] response = new byte[1024];
		ByteArrayOutputStream bs = new ByteArrayOutputStream();
		int readByte = 0;
		InputStream inner = getResponseStream();
		while ((readByte = inner.read(response)) != -1) {
			bs.write(response, 0, readByte);
		}
		inner.close();
		return bs.toByteArray();
	}

	/**
	 * form̑MsȂ܂BUiLocationwb_[jꍇ͂ǂ܂B
	 * httpNGXgReferer,Cookie,User-Agent,Host,Accept,Connectionwb_[͎Iɐ܂B<br>
	 * EUser-Agentwb_[̃ftHgJavas̃o[W("Java/1.6.0_10"Ȃ)łB<br>
	 * ERefererwb_[ɂ̓ftHgŒOɃANZXURLi[܂B<br>
	 * NX̃o[HttpHeaderList(getHttpHeaderList\bhŎ擾)ɒǉEύXhttpwb_[
	 * ΂̃wb_[NGXgɓ܂Bwb_[(User-AgentȂ)o[
	 * HttpHeaderListɒǉꍇ͂̓eŒu܂(Cookie͒u܂)B
	 * 
	 * @since 1.12
	 * @param p_URL formMURL
	 * @param p_charset 擾html̕Zbg
	 * @param p_htmlForm tH[͓̓e
	 * @return X|Xhtml
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">Zbg</a>
	 * @throws HttpSendException NGXgMɎsꍇ
	 * @throws HttpRecvException X|XMɎsꍇ
	 * @throws CookieException Cookie͂Ɏsꍇ
	 * @throws HtmlFormException NG̐Ɏsꍇ
	 */
	public String sendForm(String p_URL, String p_charset, HtmlForm p_htmlForm) 
			throws HttpSendException, HttpRecvException, CookieException, HtmlFormException {
		HttpHeaderList httpHeaderList = new HttpHeaderList();
		httpHeaderList.addList(m_httpHeaderList);
		HttpHeader httpHeader = getReferer();
		if (httpHeader!=null) httpHeaderList.add(httpHeader);
		return sendForm(p_URL, p_charset, httpHeaderList, p_htmlForm);
	}
	
	/**
	 * form̑MsȂ܂BUiLocationwb_[jꍇ͂ǂ܂B
	 * httpNGXgCookie,User-Agent,Host,Accept,Connectionwb_[͎Iɐ܂B
	 * User-Agent̃ftHgJavas̃o[W("Java/1.6.0_10"Ȃ)łB
	 * HttpHeaderListɒǉEύXhttpwb_[΂̃wb_[NGXgɓ܂B
	 * wb_[(User-AgentȂ)HttpHeaderListɒǉꍇ͂̓e
	 * u܂(Cookie͒u܂)B
	 * 
	 * @since 1.00
	 * @param p_URL formMURL
	 * @param p_charset 擾html̕Zbg
	 * @param p_httpHeaderList httpwb_[̃Xg
	 * @param p_htmlForm tH[͓̓e
	 * @return X|Xhtml
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">Zbg</a>
	 * @throws HttpSendException NGXgMɎsꍇ
	 * @throws HttpRecvException X|XMɎsꍇ
	 * @throws CookieException Cookie͂Ɏsꍇ
	 * @throws HtmlFormException NG̐Ɏsꍇ
	 */
	public String sendForm(String p_URL, String p_charset, 
			HttpHeaderList p_httpHeaderList, HtmlForm p_htmlForm) 
			throws HttpSendException, HttpRecvException, CookieException, HtmlFormException {
		if (p_htmlForm.getAction().length()<=0) return null;
		String returnValue = "";
		if (p_htmlForm.getMethod().equals("post")) {
			// POST
			try {
				String queryString = p_htmlForm.createQueryString(p_charset);
				returnValue = postHtml(p_URL,queryString,p_charset,p_httpHeaderList);
			} catch (UnsupportedEncodingException e) {
				e.printStackTrace();
				p_htmlForm.print(System.out);
				throw new HttpSendException("sendForm POST createQueryString Error: " + e.getMessage());
			}
		} else {
			// GET
			try {
				String getUrl = p_URL + "?" + p_htmlForm.createQueryString(p_charset);
				returnValue = getHtml(getUrl,p_charset,p_httpHeaderList);
			} catch (UnsupportedEncodingException e) {
				e.printStackTrace();
				p_htmlForm.print(System.out);
				throw new HttpSendException("sendForm GET createQueryString Error: " + e.getMessage());
			}
		}
		String redirect = redirectHtml(p_charset, p_httpHeaderList);
		if (!redirect.equals("")) return redirect;
		return returnValue;
	}

	/**
	 * w肵URLhtmlԂ܂BUiLocationwb_[jꍇ͂ǂ܂B
	 * Referer,Cookie,User-Agent,Host,Accept,Connectionwb_[͎Iɐ܂B<br>
	 * EUser-Agentwb_[̃ftHgJavas̃o[W("Java/1.6.0_10"Ȃ)łB<br>
	 * ERefererwb_[ɂ̓ftHgŒOɃANZXURLi[܂B<br>
	 * NX̃o[HttpHeaderList(getHttpHeaderList\bhŎ擾)ɒǉEύXhttpwb_[
	 * ΂̃wb_[NGXgɓ܂Bwb_[(User-AgentȂ)o[
	 * HttpHeaderListɒǉꍇ͂̓eŒu܂(Cookie͒u܂)B
	 * 
	 * @since 1.12
	 * @param p_URL URL
	 * @param p_charset 擾html̕Zbg
	 * @return X|Xhtml
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">Zbg</a>
	 * @throws HttpSendException NGXgMɎsꍇ
	 * @throws HttpRecvException X|XMɎsꍇ
	 * @throws CookieException Cookie͂Ɏsꍇ
	 */
	public String go(String p_URL, String p_charset) throws HttpSendException, HttpRecvException, CookieException {
		HttpHeaderList httpHeaderList = new HttpHeaderList();
		httpHeaderList.addList(m_httpHeaderList);
		HttpHeader httpHeader = getReferer();
		if (httpHeader!=null) httpHeaderList.add(httpHeader);
		return go(p_URL, p_charset, httpHeaderList);
	}
	
	/**
	 * w肵URLhtmlԂ܂BUiLocationwb_[jꍇ͂ǂ܂B
	 * Referer,Cookie,User-Agent,Host,Accept,Connectionwb_[͎Iɐ܂BUser-Agent
	 * ftHgJavas̃o[W("Java/1.6.0_10"Ȃ)łB
	 * HttpHeaderList(getHttpHeaderList\bhŎ擾)ɒǉEύXhttpwb_[
	 * ΂̃wb_[NGXgɓ܂Bwb_[(User-AgentȂ)
	 * HttpHeaderListɒǉꍇ͂̓eŒu܂(Cookie͒u܂)B
	 * 
	 * @since 1.10
	 * @param p_URL URL
	 * @param p_charset 擾html̕Zbg
	 * @param p_httpHeaderList httpwb_[̃Xg
	 * @return X|Xhtml
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">Zbg</a>
	 * @throws HttpSendException NGXgMɎsꍇ
	 * @throws HttpRecvException X|XMɎsꍇ
	 * @throws CookieException Cookie͂Ɏsꍇ
	 */
	public String go(String p_URL, String p_charset, 
			HttpHeaderList p_httpHeaderList) throws HttpSendException, HttpRecvException, CookieException {
		String returnValue = getHtml(p_URL,p_charset,p_httpHeaderList);
		String redirect = redirectHtml(p_charset, p_httpHeaderList);
		if (!redirect.equals("")) return redirect;
		return returnValue;
	}
	
	/**
	 * ߂ɃANZXURLRefererwb_[쐬܂B
	 * 
	 * @since 1.12
	 * @return Refererwb_[AxANZXĂȂꍇnullԂ܂
	 */
	private HttpHeader getReferer() {
		String prevUrl = getURL();
		if (prevUrl==null) return null;
		if (prevUrl.equals("")) return null;
		return new HttpHeader("Referer",prevUrl);
	}
	
	
	/**
	 * httpwb_[LocationǂėUHtml擾܂B
	 * 
	 * @param p_charset 擾html̕Zbg
	 * @param p_httpHeaderList httpwb_[̃Xg
	 * @return X|Xhtml
	 * @see <a href=
	 * "http://sdc.sun.co.jp/java/docs/j2se/1.4/ja/docs/ja/guide/intl/encoding.doc.html">Zbg</a>
	 * @throws HttpSendException NGXgMɎsꍇ
	 * @throws HttpRecvException X|XMɎsꍇ
	 * @throws CookieException Cookie͂Ɏsꍇ
	 */
	public String redirectHtml(String p_charset, HttpHeaderList p_httpHeaderList) 
		throws HttpSendException, HttpRecvException, CookieException {
		String returnValue = "";
		for (;;) {
	        String nextUrl = getResponseHeaderValue("Location");
	        if (nextUrl.equals("")) break;
	        returnValue = getHtml(nextUrl, p_charset, p_httpHeaderList);
		}
		return returnValue;
	}
	
	/**
	 * RlNVؒf܂B
	 * 
	 * @since 1.00
	 */
	public void close() {
		m_connection.disconnect();
	}
	
	/**
	 * ݂URLԂ܂B_CNgɌ݂URLmFł܂B
	 * xNGXgĂȂꍇnullԂ܂B
	 * 
	 * @since 1.00
	 * @return ݂URL
	 */
	public String getURL() {
		if (m_connection==null) return null;
		return m_connection.getURL().toString();
	}

	/**
	 * ݂URL̃fBNgԂ܂B
	 * _CNgɌ݂URL̃fBNgmFł܂B
	 * ݂URLhttp://robotbrain.jp/javadoc/index.htmlƂ
	 * http://robotbrain.jp/javadocԂ܂B
	 * xNGXgĂȂꍇnullԂ܂B
	 * 
	 * @since 1.00
	 * @return ݂URL̃fBNg
	 */
	public String getDirectry() {
		if (m_connection==null) return null;
		if (m_connection.getURL().toString().lastIndexOf("/")<8) return m_connection.getURL().toString();
		return m_connection.getURL().toString().substring(0,m_connection.getURL().toString().lastIndexOf("/"));
	}
	
	/**
	 * HTTP_CNg(R[h3xx̗v)ꍇtrueݒ肵܂B
	 * ̃CX^X̃ftHgtruełB
	 * CookieM̎ɔp~
	 * 
	 * @since 1.00
	 * @param p_autoRedirects HTTP_CNg(R[h3xx̗v)邩Ȃ
	 */
	@Deprecated
	public void setAutoRedirects(boolean p_autoRedirects) {
		m_autoRedirects = p_autoRedirects;
	}

	/**
	 * HTTP_CNg(R[h3xx̗v)ꍇtrueԂ܂B
	 * CookieM̎ɔp~
	 * 
	 * @since 1.00
	 * @return HTTP_CNg(R[h3xx̗v)邩Ȃ
	 */
	@Deprecated
	public boolean isAutoRedirects() {
		return m_autoRedirects;
	}
	
	/**
	 * httpwb_[XgԂ܂B
	 * 
	 * @since 1.12
	 * @return httpwb_[Xg
	 */
	public HttpHeaderList getHttpHeaderList() {
		return m_httpHeaderList;
	}
	
}
