/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.util.ArrayList;

/**
 * VOĩubN<br>
 * ̎VOiP̎VOi𓱂o܂B
 * SignalBlock͂܂̓VOiVOi̎ށi""A""
 * A"x"jPriorityZPriorityő̃VOiT
 * ܂BĂ̍ő̃VOi""VOiPriorityZ
 * l100ɒBĂ΂̃VOiAEgvbg̃VOi
 * ɂ܂B
 * ǂ̃VOiɂłȂꍇi=50,=50̂悤ɃVO
 * iPriorityŊꂽꍇƁAőVOi""VOi
 * PriorityZĂ100ɒBȂꍇjADefaultSignalAE
 * gvbg̃VOiƂ܂B
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
@TypeSignalBlock
@EnabledDefaultSignal
@InputComponentList(values={"@Signal"})
public class SignalBlock extends Signal {

	/**
	 * ͎VOi
	 * 
	 * @since 1.00
	 */
	private final ArrayList<Signal> m_inputSignalList;
	
	/**
	 * SignalBlock𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 * @param p_priority Dx
	 */
	public SignalBlock(String p_label, int p_priority) {
		super(p_label, p_priority);
		m_inputSignalList = new ArrayList<Signal>();
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.Signal#getJudgmentResult()
	 */
	@Override
	public JudgmentResult getJudgmentResult() throws IndexStreamException {
		// ̓`FbN
		Tag firstTag = getInputTag();
		if (firstTag==null) return new JudgmentResult(null,NmSignal.NOSIGNAL);
		// Wv
		SummaryPriority sumPriority = getSummaryPriority();
		SimpleSignal max = sumPriority.getMaxSignal(firstTag);
		// VOi
		NmSignal returnValue = getDefaultSignal();
		if (max!=null) {
			if (max.getPriority()+sumPriority.getNeutral()>=100) {
				returnValue = max.getJudgmentResult().getSignal();
			}
		}
		setDetails("[" + getLabel() + "]" + returnValue.toString());
		return new JudgmentResult(firstTag,returnValue);
	}
	
	/**
	 * ̓VOĩ^OԂ܂B
	 * 
	 * @since 1.20
	 * @return ^O
	 * @throws IndexStreamException eNjJwW̓ǂݍ݂ňُ킪ꍇ
	 */
	protected Tag getInputTag() throws IndexStreamException {
		if (m_inputSignalList.size()<=0) return null;
		return m_inputSignalList.get(0).getJudgmentResult().getTag();
	}
	
	/**
	 * ͎VOiǉ܂B
	 * 
	 * @since 1.00
	 * @param p_tradeSignal VOi
	 */
	public void addTradeSignal(Signal p_tradeSignal) {
		m_inputSignalList.add(p_tradeSignal);
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.Signal#getDetails()
	 */
	@Override
	public String getDetails() {
		StringBuilder returnValue = new StringBuilder();
		for (Signal sig: m_inputSignalList) {
			returnValue.append(sig.getDetails());
		}
		returnValue.append(super.getDetails());
		return returnValue.toString();
	}
	
	/**
	 * w̎VOi̗Dx̍ZԂ܂B
	 * 
	 * @since 1.21
	 * @param p_tradeSignal VOi
	 * @return Dx̍Zl
	 */
	private SummaryPriority getSummaryPriority() throws IndexStreamException {
		SummaryPriority returnValue = new SummaryPriority();
		for (Signal inputSignal : m_inputSignalList) {
			switch (inputSignal.getJudgmentResult().getSignal()) {
			case LONG:
				returnValue.addLong(inputSignal.getPriority());
				break;
			case SHORT:
				returnValue.addShort(inputSignal.getPriority());
				break;
			case REST:
				returnValue.addRest(inputSignal.getPriority());
				break;
			case NEUTRAL:
				returnValue.addNeutral(inputSignal.getPriority());
				break;
			}
		}
		return returnValue;
	}
	
}
