/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.io.PrintStream;

import jp.robotbrain.framework.Current;

/**
 * [\N
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class CandleStick extends IndexPoint implements Current,Cloneable {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * nl
	 * 
	 * @since 1.00
	 */
	private final double m_open;

	/**
	 * l
	 * 
	 * @since 1.00
	 */
	private final double m_high;
	
	/**
	 * l
	 * 
	 * @since 1.00
	 */
	private final double m_low;

	/**
	 * Il
	 * 
	 * @since 1.00
	 */
	private final double m_close;

	/**
	 * CandleStick𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_tag ^O
	 * @param p_open nl
	 * @param p_high l
	 * @param p_low l
	 * @param p_close Il
	 */
	public CandleStick(Tag p_tag, double p_open, double p_high, double p_low, double p_close) {
		super(p_tag, p_close);
		m_open = p_open;
		m_high = p_high;
		m_low = p_low;
		m_close = p_close;
	}
	
	/**
	 * ̃IuWFNg̃Rs[쐬ĕԂ܂B
	 * 
	 * @since 2.01
	 * @return ̃IuWFNg̃Rs[ 
	 */
	public CandleStick clone() {
		CandleStick returnValue = new CandleStick(this.getTag(), 
				this.m_open, this.m_high, this.m_low, this.m_close);
		return returnValue;
	}
	
	/**
	 * nlԂ܂B
	 * 
	 * @since 1.00
	 * @return nl
	 */
	public double getOpen() {
		return m_open;
	}

	/**
	 * lԂ܂B
	 * 
	 * @since 1.00
	 * @return l
	 */
	public double getHigh() {
		return m_high;
	}

	/**
	 * lԂ܂B
	 * 
	 * @since 1.00
	 * @return l
	 */
	public double getLow() {
		return m_low;
	}

	/**
	 * IlԂ܂B
	 * 
	 * @since 1.00
	 * @return Il
	 */
	public double getClose() {
		return m_close;
	}

	@Override
	public boolean isSet() {
		return true;
	}

	/**
	 * lAlAIl̕ϒlԂ܂B
	 * 
	 * @since 1.00
	 * @return lAlAIl̕ϒl
	 */
	public double getAvg() {
		return (getHigh() + getLow() + getClose()) / 3;
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexObject#printHeader(java.io.PrintStream)
	 */
	@Override
	public void printHeader(PrintStream p_out) {
		p_out.println("Tag,Open,High,Low,Close,Avg");
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexObject#print(java.io.PrintStream)
	 */
	@Override
	public void print(PrintStream p_out) {
		p_out.println("'" + getTag().getString() + "'," + getOpen() + "," + 
				getHigh() + "," + getLow() + "," + getClose() + "," + getAvg());
	}

}
