/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

/**
 * DMĨXg
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class DmiList extends IndexObjectList<Dmi> {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * DMI߂\[X̃[\N
	 * 
	 * @since 1.00
	 */
	private final int m_ccount;
	
	/**
	 * DXC
	 * 
	 * @since 1.00
	 */
	private final SimpleLine m_dxLine;
	
	/**
	 * DI+C
	 * 
	 * @since 1.00
	 */
	private final SimpleLine m_diPlusLine;

	/**
	 * DI-C
	 * 
	 * @since 1.00
	 */
	private final SimpleLine m_diMinusLine;

	/**
	 * DmiList𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_ccount DMIZô߂Ɏg[\N
	 */
	public DmiList(int p_ccount) {
		super();
		m_ccount = p_ccount;
		m_dxLine = new SimpleLine();
		m_diPlusLine = new SimpleLine();
		m_diMinusLine = new SimpleLine();
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexObjectList#remove(java.lang.String)
	 */
	@Override
	public void remove(String p_date) {
		super.remove(p_date);
		m_dxLine.remove(p_date);
		m_diPlusLine.remove(p_date);
		m_diMinusLine.remove(p_date);
	}
	
	/**
	 * \[X[\NXgDMIZoăXgɒǉ܂B
	 * 
	 * @since 1.00
	 * @param p_src \[X[\NXg
	 */
	public void addObject(CandleStickList p_src) {
		// TCY`FbN
		if (p_src==null) return;
		// \[X+1{̃[\NKv
		if (p_src.size()<=m_ccount) return; 
		// DMI̐
		Dmi dmi = createDMI(p_src);
		CandleStick c = p_src.getLast();
		// DMIXgɒǉ
		add(dmi);
		// DI+C֒ǉ
		m_diPlusLine.addPoint(new IndexPoint(c.getTag(),dmi.getPlusDi()));
		// DI-C֒ǉ
		m_diMinusLine.addPoint(new IndexPoint(c.getTag(),dmi.getMinusDi()));
		// DXC֒ǉ
		m_dxLine.addPoint(new IndexPoint(c.getTag(),dmi.getDx()));
	}	
	
	/**
	 * DXCԂ܂B
	 * 
	 * @since 1.00
	 * @return DXC
	 */
	public IndexLine getDxLine() {
		return m_dxLine;
	}
	
	/**
	 * DI+CԂ܂B
	 * 
	 * @since 1.00
	 * @return DI+C
	 */
	public IndexLine getDiPlusLine() {
		return m_diPlusLine;
	}

	/**
	 * DI-CԂ܂B
	 * 
	 * @since 1.00
	 * @return DI-C
	 */
	public IndexLine getDiMinusLine() {
		return m_diMinusLine;
	}
	
	/**
	 * \[X[\NXgDMI𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_src \[X[\NXg
	 * @return DMI
	 */
	private Dmi createDMI(CandleStickList p_src) {
		// DMI[\N͈̔͂ݒ
		int begin = p_src.size() - m_ccount;
		int end = p_src.size();
		// vl̏
		double sumPlusDm = 0;
		double sumMinusDm = 0;
		double sumTr = 0;
		// DMIZo
		for (int i=begin; i<end; i++) {
			CandleStick curCandleStick = p_src.get(i);
			CandleStick prevCandleStick = p_src.get(i-1);
			// +DM=̍l-O̍l
			double plusDm = curCandleStick.getHigh() - prevCandleStick.getHigh();
			// -DM=Öl-̈l@
			double minusDm = prevCandleStick.getLow() - curCandleStick.getLow();
			// (1) +DM<0A-DM<0̏ꍇA+DM=0A-DM=0
			if (plusDm < 0 && minusDm < 0) {
				minusDm = 0;
				plusDm = 0;
			}
			// (2) +DM>-DM̏ꍇA+DM=̍l-O̍lA-DM=0 
			if (plusDm > minusDm) {
				minusDm = 0;
			}
			// (3) +DM<-DM̏ꍇA+DM=0A-DM=Öl-̈l
			if (plusDm < minusDm) {
				plusDm = 0;
			}
			// (4) +DM=-DM̏ꍇA+DM=0A-DM=0
			if (plusDm == minusDm) {
				minusDm = 0;
				plusDm = 0;
			}
			// Wv
			sumPlusDm += plusDm;
			sumMinusDm += minusDm;
			sumTr += UtilSignal.calcTrueRange(prevCandleStick, curCandleStick);
		}
		/*
                m_ccount+DM̍v
          +DI = ----------------------~100
                m_ccountTR̍v

                m_ccount-DM̍v
          -DI = ----------------------~100
                m_ccountTR̍v
        */
		double p = sumPlusDm / sumTr * 100;   
		double m = sumMinusDm / sumTr * 100;
		// DMI
		CandleStick c = p_src.getLast();
		return new Dmi(c.getTag(),p,m);
	}

}
