#include "roast/graphics/directx/dx9.hpp"
#include "roast/graphics/directx/dx10.hpp"
#include "roast/graphics/directx/shader_param.hpp"
#include "roast/windows/window.hpp"
#include "roast/windows/message_loop.hpp"
#include <stdio.h>

using namespace ::roast::directx::graphics;
using namespace ::roast::directx::dx10;

/*typedef int A[4];
A hoge(){
	A a;
	return a; 
}*/
void main( void )
{
	try
	{
		graphics::first f;
		graphics::first f2(f);
		graphics::first f3;
		//f.get_device_caps(0,(D3DDEVTYPE)0);
		printf("graphics::first Construct... OK\n");

		/*
		//////////////

		if ( f.test_device(0, D3DDEVTYPE_HAL) )
			printf("graphics::first::test_device(): D3DDEVTYPE_HAL Supported.\n");
		else
			printf("graphics::first::test_device(): D3DDEVTYPE_HAL Not Supported.\n");

		if ( f.test_device(0, D3DDEVTYPE_REF) )
			printf("graphics::first::test_device(): D3DDEVTYPE_REF Supported.\n");
		else
			printf("graphics::first::test_device(): D3DDEVTYPE_REF Not Supported.\n");

		if ( f.test_device(0, D3DDEVTYPE_SW) )
			printf("graphics::first::test_device(): D3DDEVTYPE_SW Supported.\n");
		else
			printf("graphics::first::test_device(): D3DDEVTYPE_SW Not Supported.\n");

		//////////////

		graphics::disp_mode dm = f.get_current_display_mode();
		printf("\n=== Current Display Mode ===\n");
		printf("Width=%d\n", dm.get_width());
		printf("Height=%d\n", dm.get_height());
		printf("RefreshRate=%d\n", dm.get_refresh_rate());
		*/

		/////////////////////////////////////////////////////////////////////////////////////

		::roast::windows::window w("Test");
		w.start("hoge",500,500);

		graphics::device d(f);
		//graphics::device d2(f);
		d.start(w, false);
		//d2.start(w, false);
		d.begin_scene();
		d.clear(0xff400000);
		d.end_scene();
		d.present();
		/*d2.begin_scene();
		d2.clear(0xff800000);
		d2.end_scene();
		d2.present();*/

		shader_param_<shader_param_type::float3, shader_param_type::float4, shader_param_type::int_> ss;
		printf("size=%d\n", sizeof(shader_param_<shader_param_type::float3, shader_param_type::float4, shader_param_type::int_>) );

		//shader_model<shader_model_type::fx,4> sm;
		//printf("%s\n", sm.to_string() );

struct MyVertex {
        D3DXVECTOR3 Pos;
        D3DXVECTOR3 Color;
};
   MyVertex vtx[] = {
           D3DXVECTOR3( 0.0f, 0.5f, 0.5f ), D3DXVECTOR3( 1.0f, 1.0f, 1.0f ),
           D3DXVECTOR3( 0.5f, -0.5f, 0.5f ), D3DXVECTOR3( 1.0f, 1.0f, 1.0f ),
           D3DXVECTOR3( -0.5f, -0.5f, 0.5f ), D3DXVECTOR3( 1.0f, 1.0f, 1.0f )
   };
   D3D10_INPUT_ELEMENT_DESC MyVertexDesc[] = {
           { "POSITION_IN", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, 0, D3D10_INPUT_PER_VERTEX_DATA, 0 },
           { "COLOR", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, sizeof(D3DXVECTOR3), D3D10_INPUT_PER_VERTEX_DATA, 0 },
   };
		graphics::input_vertex_buffer<MyVertex> ivb(d, vtx, sizeof(vtx));
		graphics::render_device ren(d);
		ren.set_vertex_buffer(ivb);
		graphics::effect efx(d,
			graphics::effect::construct_by_file("test.fx"),
			shader_model<shader_model_type::fx,4>() );
		//graphics::technique tc = efx.get_technique("SimpleRender");
		//graphics::pass ps = tc.get_pass("P0");
		graphics::pass ps = efx["Test"]["Test"];
		ren.setup_input_layout<MyVertex>(MyVertexDesc,2,ps);

		ren.apply_pass(ps);
		ren.draw_primitive(D3D10_PRIMITIVE_TOPOLOGY_TRIANGLELIST, 3);
		d.present();

		::roast::windows::peek_message_loop lp;
		lp.start();
		//Sleep(1000);

	}
	catch( ::std::string &s )
	{
		printf("\n######################################################################\n");
		printf("%s\n", s.c_str() );
	}
}
