//	Roast+ License

#ifndef __SFJP_ROAST_EX__windows__registory_HPP__
#define __SFJP_ROAST_EX__windows__registory_HPP__

#include <windows.h>
#include <string>
#include <map>

namespace roast
{
	template <typename _Map, typename _Key, typename _Value>
	_Value find_map_or_default( const _Map &mp, const _Key& ky, const _Value& not_founded_value )
	{
		_Map::const_iterator it = mp.find(ky);
		if ( it == mp.end() )
			return not_founded_value;
		else
			return it->second;
	}

	////////////

	namespace windows
	{
		namespace registory
		{
			/////////////////////////////////////////////

			class exception : public windows_exception
			{
			public:
				exception(const char* s) : windows_exception(s) {}
				exception(const ::std::string& s) : windows_exception(s) {}
			};

			class api_exception : public registory::exception
			{
			public:
				api_exception(const char* s) : registory::exception(s) {}
				api_exception(const ::std::string& s) : registory::exception(s) {}
			};

			/////

			class value
			{
			};

			/////

			namespace _internal
			{
				class rootkey_map
				{
				private:
					::std::map<::std::string, ::HKEY> m_map;
					void _make_rootkey_map()
					{
						m_map["HKEY_CLASSES_ROOT"] = HKEY_CLASSES_ROOT;
						m_map["HKEY_CURRENT_USER"] = HKEY_CURRENT_USER;
						m_map["HKEY_LOCAL_MACHINE"] = HKEY_LOCAL_MACHINE;
						m_map["HKEY_USERS"] = HKEY_USERS;
						m_map["HKEY_PERFORMANCE_DATA"] = HKEY_PERFORMANCE_DATA;
#ifdef HKEY_PERFORMANCE_TEXT
						m_map["HKEY_PERFORMANCE_TEXT"] = HKEY_PERFORMANCE_TEXT;
						m_map["HKEY_PERFORMANCE_NLSTEXT"] = HKEY_PERFORMANCE_NLSTEXT;
#endif
						m_map["HKEY_CURRENT_CONFIG"] = HKEY_CURRENT_CONFIG;
						m_map["HKEY_DYN_DATA"] = HKEY_DYN_DATA;
					}
				public:
					rootkey_map(){ _make_rootkey_map(); }
					::HKEY get_root_key(const char* szRootKeyName) const {
						return find_map_or_default(m_map, szRootKeyName, (HKEY)NULL);
					}
				};
			}
			////
			
			class key
			{
			private:
				static const _internal::rootkey_map _m_rootkey_map;
				::HKEY m_hKey;
				::std::string m_nowKey;
				bool m_mode_write;

				//	Query Infos
				DWORD m_dwSubKeyCount;
				DWORD m_dwValuesCount;
				DWORD m_dwMaxSubKeyLen;
				DWORD m_dwMaxValueNameLen;
				DWORD m_dwMaxValueLen;

				/////////////////////////////////////////////

				bool _get_any_value(const char* szValueName, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData) const 
				{
					ZeroMemory( lpData, *lpcbData );
					LONG r = ::RegQueryValueEx(
						m_hKey,			//	hKey		- L[̃nh
						szValueName,	//	lpValueName	- WXgGg
						NULL,			//	lpReserved	- \ς
						lpType,			//	lpType		- f[^^i[obt@
						lpData,			//	lpData		- f[^i[obt@
						lpcbData		//	lpcbData	- f[^obt@̃TCY
					);
					if ( r == ERROR_SUCCESS )
						return true;
					else {
						return false;
					}
				}

				//	L[Ɋւe擾Ă
				void _update_query_infos()
				{
					//	擾
					LONG r = ::RegQueryInfoKey(
						m_hKey,				//	hKey					- ₢킹ׂL[̃nh
						NULL,				//	lpClass					- NXi[obt@
						NULL,				//	lpcClass				- NXobt@̃TCY
						NULL,				//	lpReserved				- \ς
						&m_dwSubKeyCount,	//	lpcSubKeys				- TuL[̐
						&m_dwMaxSubKeyLen,	//	lpcMaxSubKeyLen			- TuL[̍Œ̒
						NULL,				//	lpcMaxClassLen			- NX̍Œ̒
						&m_dwValuesCount,	//	lpcValues				- WXgGg̐
						&m_dwMaxValueNameLen,//	lpcMaxValueNameLen		- WXgGg̍Œ̒
						&m_dwMaxValueLen,	//	lpcMaxValueLen			- WXgGg̃f[^̍Œ̒
						NULL,				//	lpcbSecurityDescriptor	- ZLeBLqq̒
						NULL				//	lpftLastWriteTime		- Ō̏ݎ
					);

					if ( r != ERROR_SUCCESS )
						api_exception("::RegQueryInfoKey() Failed.");
				}
				bool _open_ex(::HKEY hParentKey, lpctstr_t szSubKey)
				{
					DWORD dwMode = ( m_mode_write ? KEY_ALL_ACCESS : KEY_READ );
					LONG lRet = ::RegOpenKeyEx(hParentKey, szSubKey, 0, dwMode, &m_hKey );
					if ( lRet != ERROR_SUCCESS )
						return false;
					return true;
				}
			public:
				key(const key& parent, const char* szSubKey){}
				key(const key& parent, const char* szSubKey, bool mode_write){}
				key(const char* szKey, bool mode_write=false){ m_hKey = NULL; m_mode_write=mode_write; key::open(szKey, mode_write); }
				key(bool mode_write=false){ m_hKey = NULL; m_mode_write=mode_write; }
				virtual ~key(){ key::close(); }

				//bool open(const char* szKey){ return open(szKey, m_mode_write); }
				//bool open(const char* szKey, bool mode_write)
				bool open(lpctstr_t szKey, bool mode_write){ m_mode_write=mode_write; return open(szKey); }
				bool open(lpctstr_t szKey)
				{
					if ( m_hKey != NULL )
						close();

					char szRootKeyName[32];
					strncpy(szRootKeyName, szKey, sizeof(szRootKeyName)-1);
					szRootKeyName[sizeof(szRootKeyName)-1] = '\0';

					const char* p = strchr(szKey, '\\');
					if ( p == NULL )
						return false;
					if ( (p-szKey) < sizeof(szRootKeyName) )
						szRootKeyName[p-szKey] = '\0';

					::HKEY hRootKey = _m_rootkey_map.get_root_key(szRootKeyName);
					if ( hRootKey == NULL )
						return false;

					return _open_ex(hRootKey, p+1);
				}
				bool close(){
					if ( m_hKey != NULL ){
						if ( ::RegCloseKey( m_hKey ) != ERROR_SUCCESS )
							return false;
						m_hKey = NULL;
					}
					return true;
				}

				registory::key get_child(lpctstr_t szSubKey)
				{
					return registory::key(*this, szSubKey);
				}
				registory::key get_child_by_index(unsigned int index)
				{
					/*::std::string s = get_subkey_name(index);
					if ( s.length() == 0 )
					{
					}*/
					return registory::key(*this, get_subkey_name(index).c_str());
				}

				/////

				DWORD get_dword_value(const char* szValueName) const 
				{
					DWORD dwType = REG_NONE;
					DWORD dwBufSize = sizeof(DWORD);
					DWORD dwValue = 0;

					bool r = _get_any_value(szValueName, &dwType, (BYTE*)&dwValue, &dwBufSize);
					if ( r == false || dwType != REG_DWORD)
						return false;
					return false;
				}
				const char* get_str_value(const char* szValueName, char* szOutBuffer, int nOutBufferSize) const 
				{
					DWORD dwType = REG_NONE;
					DWORD dwBufSize = nOutBufferSize;

					bool r = _get_any_value( szValueName, &dwType, (BYTE*)szOutBuffer, &dwBufSize );
					if ( r != true || dwType != REG_SZ)
						return NULL;
					return szOutBuffer;
				}
				::std::string get_str_value(const char* szValueName) const 
				{
					DWORD dwType = REG_NONE;
					DWORD dwBufSize = 0;

					//	Get Need Buffer Size. (to dwBufSize)
					bool r = _get_any_value( szValueName, &dwType, NULL, &dwBufSize );
					if ( r != true )
						return "";

					::std::string s(dwBufSize, 0);

					//	Retry Get.
					r = _get_any_value( szValueName, &dwType, (BYTE*)s.data(), &dwBufSize );
					if ( r != true || dwType != REG_SZ)
						return "";
					return s;
				}

				///////////////////////////////////////////////////////////////////////

				::std::string get_subkey_name(unsigned int index){
					_update_query_infos();

					if ( m_dwSubKeyCount == 0 )
						throw registory::exception("registory::key::get_subkey_name() Not have Sub Key.");

					if ( index > m_dwSubKeyCount-1 )
						throw registory::exception("registory::key::get_subkey_name() Invalid index.");

					::std::string s(m_dwMaxSubKeyLen, 0);
					DWORD dwBufSize = m_dwMaxSubKeyLen;
					LONG r = ::RegEnumKeyEx(m_hKey,index,(LPSTR)s.data(),&dwBufSize, NULL,NULL,NULL,NULL);
					if ( r != ERROR_SUCCESS )
						throw registory::api_exception("registory::key::get_subkey_name()  ::RegEnumKeyEx() Failed.");
						//return "";
					return s;
				}
				::std::string get_value_name(unsigned int index){
					_update_query_infos();

					if ( m_dwValuesCount == 0 )
						throw registory::exception("registory::key::get_value_name() Not have Value.");

					if ( index > m_dwValuesCount-1 )
						throw registory::exception("registory::key::get_value_name() Invalid index.");

					::std::string s(m_dwMaxValueNameLen, 0);
					DWORD dwBufSize = m_dwMaxValueNameLen;
					LONG r = ::RegEnumValue(m_hKey,index,(LPSTR)s.data(),&dwBufSize, NULL,NULL,NULL,NULL);
					if ( r != ERROR_SUCCESS )
						throw registory::api_exception("registory::key::get_value_name()  ::RegEnumValue() Failed.");
						//return "";
					return s;
				}

				unsigned int get_child_key_count(){ _update_query_infos(); return m_dwSubKeyCount; }
				unsigned int get_value_count(){ _update_query_infos(); return m_dwValuesCount; }

				::HKEY get_hkey(){ return m_hKey; }
				operator ::HKEY (){ return get_hkey(); }
			};
			const _internal::rootkey_map key::_m_rootkey_map;

			/////////////////////////////////////////////
		}

		typedef registory::exception reg_exception;
		typedef registory::key reg_key, regkey;
	}
}

#endif//__SFJP_ROAST_EX__windows__registory_HPP__
