//	Roast+ License

#ifndef __SFJP_ROAST_EX__windows__message_loop_HPP__
#define __SFJP_ROAST_EX__windows__message_loop_HPP__

#include <windows.h>
#include <string>
#include <map>

namespace roast
{
	namespace windows
	{
		/////////////////////////////////////////////////////////////////////////////////////////
		
		class message_loop
		{
		public:
			void start()
			{
				MSG msg;
				BOOL bRet;
				while ( (bRet = GetMessage( &msg, NULL, 0, 0 )) != 0 ) {
					if (bRet == -1) {
						//handle the error and possibly exit
					} else {
						TranslateMessage (&msg);
						DispatchMessage (&msg);
					}
				}
			}
		};

		///////

		class peek_message_loop
		{
		protected:

		public:
			void start()
			{
				MSG msg;
				do {
					if( PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE ) )
					{
						TranslateMessage( &msg );
						DispatchMessage( &msg );
					}
					else
					{
						Sleep(1);
					}
				} while( msg.message!=WM_QUIT );
			}
		};
		
		/////////////////////////////////////////////////////////////////////////////////////////
	}
}

#endif//__SFJP_ROAST_EX__windows__message_loop_HPP__
