//	Roast+ License
/*

*/
#ifndef __SFJP_ROAST_EX__windows__menu_HPP__
#define __SFJP_ROAST_EX__windows__menu_HPP__

#include <windows.h>
#include <string>

namespace roast
{
	namespace windows
	{
	/*	typedef ::LPCTSTR lpctstr_t;
		class windows_exception : public ::std::string
		{
		public:
			windows_exception(const char* s) : ::std::string(s) {}
			windows_exception(const ::std::string& s) : ::std::string(s) {}
		};*/
		
		class windows_menu_exception : public windows_exception
		{
		public:
			windows_menu_exception(const char* s) : windows_exception(s) {}
			windows_menu_exception(const ::std::string& s) : windows_exception(s) {}
		};
		
		class windows_menu_api_exception : public windows_menu_exception
		{
		private:
			::std::string _get_api_ret_code_s(){
				char work[64];
				sprintf(work, " GetLastError() = %d", ::GetLastError() );
				return work;
			}
		public:
			windows_menu_api_exception(const char* s) : windows_menu_exception(::std::string(s) + _get_api_ret_code_s()) {}
			windows_menu_api_exception(const ::std::string& s) : windows_menu_exception(s) {}
		};

		/////////////////////////////////////////////////

		class menuitem
		{
		private:
			bool _SetMenuItemInfo(){
				return ( ::SetMenuItemInfo(m_hMenu, uItem, fByPosition, &minfo) == TRUE );
			}
			void _GetMenuItemInfo(){
				if( ::GetMenuItemInfo(m_hMenu, uItem, fByPosition, &minfo) == FALSE )
					throw windows_menu_api_exception("::GetMenuItemInfo() Failed.");
			}
			void _update(){
				if ( m_hMenu )
					_SetMenuItemInfo();
			}
		protected:
			::HMENU m_hMenu;
			::HMENU m_hBulkMenuBackup;
			UINT uItem;
			BOOL fByPosition;
			MENUITEMINFO minfo;
			char m_szText[128];
		public:
			struct sys_bitmap{
				enum enums_
				{
					popup_size_restore = (int)HBMMENU_POPUP_RESTORE,
					popup_minimize = (int)HBMMENU_POPUP_MINIMIZE,
					popup_maximize = (int)HBMMENU_POPUP_MAXIMIZE,
					popup_close = (int)HBMMENU_POPUP_CLOSE,

					mbar_size_restore = (int)HBMMENU_MBAR_RESTORE,
					mbar_minimize = (int)HBMMENU_MBAR_MINIMIZE,
					mbar_minimize_disable = (int)HBMMENU_MBAR_MINIMIZE_D,
					mbar_close = (int)HBMMENU_MBAR_CLOSE,
					mbar_close_disable = (int)HBMMENU_MBAR_CLOSE_D,

					owner_event_processed = (int)HBMMENU_CALLBACK,
					//HBMMENU_SYSTEM

					_end
				};
			};
		public:
			menuitem(HMENU hMenu, UINT uItem_in, BOOL fByPosition_in)
				: m_hMenu(hMenu), uItem(uItem_in), fByPosition(fByPosition_in), m_hBulkMenuBackup(NULL) {
					ZeroMemory(&minfo, sizeof(minfo)); minfo.cbSize = sizeof(minfo); minfo.fMask = 0x1ef;//0xffffffff - 0x10;
					minfo.dwTypeData = m_szText; minfo.cch = sizeof(m_szText); _GetMenuItemInfo(); }
					//ZeroMemory(&minfo, sizeof(minfo)); minfo.cbSize = sizeof(minfo); }
			menuitem()
				: m_hMenu(NULL), uItem(0), fByPosition(0), m_hBulkMenuBackup(NULL) {
					ZeroMemory(&minfo, sizeof(minfo)); minfo.cbSize = sizeof(minfo); minfo.fMask = 0x1ef; }
			menuitem(const MENUITEMINFO& minfo_in)
				: m_hMenu(NULL), uItem(0), fByPosition(0), m_hBulkMenuBackup(NULL), minfo(minfo_in) {}

			///////////////////////////////////////////////////

			void set_text(lpctstr_t szText){
				//minfo.dwTypeData = (LPSTR)szText;
				//minfo.cch = strlen(szText);

				if ( strlen(szText) > sizeof(m_szText)-1 )
					windows_menu_exception("menuitem::set_text() szText is too long. (Max length 127 byte)");
				strcpy(m_szText, szText);

				minfo.dwTypeData = (LPSTR)m_szText;
				minfo.cch = sizeof(m_szText)-1;
				_update();
			}
			void set_id(UINT id){ minfo.wID = id; _update(); }
			void set_userdata(ULONG_PTR dwAnyData){ minfo.dwItemData = dwAnyData; _update(); }
			void set_submenu(HMENU hSubMenu){ minfo.hSubMenu = hSubMenu; _update(); }

			void set_bitmap(HBITMAP hBitmap){ minfo.hbmpItem = hBitmap; _update(); }
			void set_bitmap(sys_bitmap::enums_ eSysBitmap){ minfo.hbmpItem = (HBITMAP)eSysBitmap; _update(); }
			void set_checked_bitmap(HBITMAP hBitmap){ minfo.hbmpChecked = hBitmap; _update(); }
			void set_unchecked_bitmap(HBITMAP hBitmap){ minfo.hbmpUnchecked = hBitmap; _update(); }

			void enable(){ ROAST_BIT_NOT(minfo.fState, MFS_DISABLED); ROAST_BIT_NOT(minfo.fState, MFS_GRAYED); _update(); }
			void disable(){ minfo.fState |= MFS_DISABLED; minfo.fState |= MFS_GRAYED; _update(); }
			void check(){ ROAST_BIT_NOT(minfo.fState, MFS_CHECKED); _update(); }
			void uncheck(){ minfo.fState |= MFS_CHECKED; _update(); }
			void setdefault(){ ROAST_BIT_NOT(minfo.fState, MFS_DEFAULT); _update(); }
			void undefault(){ minfo.fState |= MFS_DEFAULT; _update(); }
			void hilite(){ ROAST_BIT_NOT(minfo.fState, MFS_HILITE); _update(); }
			void unhilite(){ minfo.fState |= MFS_HILITE; _update(); }

			////////////////////////////////////////////////

  /*  UINT    fMask;         // 擾܂͐ݒ肷郁o
    UINT    fType;         // ACẽ^Cv*/
			void bulk_start(){
				m_hBulkMenuBackup = m_hMenu;
				m_hMenu = NULL;
			}
			void bulk_end(){
				m_hMenu = m_hBulkMenuBackup;
				m_hBulkMenuBackup = NULL;
				_SetMenuItemInfo();
			}

			menuitem& operator = (const menuitem& from){
				m_hMenu = from.m_hMenu;
				m_hBulkMenuBackup = from.m_hBulkMenuBackup;
				uItem = from.uItem;
				fByPosition = from.fByPosition;
				minfo = from.minfo;
				_update();
			}

			MENUITEMINFO get_mmi(){ return minfo; }
			MENUITEMINFO& get_mmi_ref(){ return minfo; }
			const MENUITEMINFO& get_mmi_cref() const { return minfo; }
			MENUITEMINFO* get_mmi_ptr(){ return &minfo; }
			const MENUITEMINFO* get_mmi_cptr() const { return &minfo; }

			operator MENUITEMINFO () const { return minfo; }
			operator const MENUITEMINFO () const { return minfo; }
		};

		///////////////////////////////////////////////////////////

		class menu
		{
		private:
			bool _InsertMenu(UINT uPosition, UINT uFlags, UINT_PTR uIDNewItem, lpctstr_t lpNewItem){
				return ( InsertMenu(m_hMenu, uPosition, uFlags, uIDNewItem, lpNewItem) == TRUE );
			}
			bool _InsertMenuInfo(UINT uItem, BOOL fByPosition, LPCMENUITEMINFO lpmii){
				return ( InsertMenuItem(m_hMenu, uItem, fByPosition, lpmii) == TRUE );
			}
			/*bool _SetMenuItemInfo(UINT uItem, BOOL fByPosition, LPMENUITEMINFO lpmii){
				return ( SetMenuItemInfo(m_hMenu, uItem, fByPosition, lpmii) == TRUE );
			}*/
			void destroy_menu()
			{
				if ( !m_bAttachedMenu )
					if ( ::DestroyMenu(m_hMenu) == FALSE )
						windows_menu_exception("::DestroyMenu() Returned Error.");
			}
		protected:
			::HMENU m_hMenu;
			bool m_bAttachedMenu;
		public:
			static class popup_type_{} popup_type;
		public:
			menu(){
				m_bAttachedMenu = false;
				m_hMenu = ::CreateMenu();
				if ( m_hMenu == NULL )
					windows_menu_exception("::CreateMenu() Returned Error.");
			}
			menu(const popup_type_&){
				m_bAttachedMenu = false;
				m_hMenu = ::CreatePopupMenu();
				if ( m_hMenu == NULL )
					windows_menu_exception("::CreatePopupMenu() Returned Error.");
			}
			menu(HMENU hMenuAttach){
				m_bAttachedMenu = true;
				m_hMenu = hMenuAttach;
			}
			virtual ~menu(){ destroy_menu(); }
			
			//
			void attach(HMENU hMenuAttach){
				destroy_menu();
				
				m_bAttachedMenu = true;
				m_hMenu = hMenuAttach;
			}
			void attach(const menu& menu_in){
				destroy_menu();
				
				m_bAttachedMenu = true;
				m_hMenu = menu_in.m_hMenu;
			}
			
			//////
			
			bool insert(unsigned int index, lpctstr_t szText, UINT itemId=0){ return _InsertMenu(index, MF_BYPOSITION, itemId, szText); }
			bool insert(unsigned int index, const MENUITEMINFO& mii){ return _InsertMenuInfo(index, TRUE, &mii); }
			bool insert_separater(unsigned int index){ return _InsertMenu(index, MF_BYPOSITION | MF_SEPARATOR, NULL, NULL); }

			bool insert_byid(unsigned int before_id, lpctstr_t szText, UINT itemId=0){ return _InsertMenu(before_id, MF_BYCOMMAND, itemId, szText); }
			bool insert_byid(unsigned int before_id, const MENUITEMINFO& mii){ return _InsertMenuInfo(before_id, FALSE, &mii); }
			bool insert_separater_byid(unsigned int before_id){ return _InsertMenu(before_id, MF_BYCOMMAND | MF_SEPARATOR, NULL, NULL); }

			bool add(lpctstr_t szText, UINT itemId=0){ return insert(-1, szText, itemId); }
			bool add(const MENUITEMINFO& mii){ return insert(-1, mii); }
			bool add_separater(){ return insert_separater(-1); }
			bool add_sep(){ return add_separater(); }

			void attach_submenu(unsigned int index, HMENU hSubMenu){ get(index).set_submenu(hSubMenu); }
			void attach_submenu_byid(unsigned int itemId, HMENU hSubMenu){ get_byid(itemId).set_submenu(hSubMenu); }
			
			///////////////////////////////////////////////

			menuitem get(unsigned int index){ return menuitem(m_hMenu, index, TRUE); }
			menuitem get_byid(UINT itemId){ return menuitem(m_hMenu, itemId, FALSE); }
			menuitem operator [](int index){ return get(index); }

			//////

			HMENU get_hmenu(){ return m_hMenu; }
			operator HMENU (){ return get_hmenu(); }
		};

		menu::popup_type_ menu::popup_type;
		
		////////////////////////////////////////////////////////////////
	}
}

#endif//__SFJP_ROAST_EX__windows__menu_HPP__
