//	Roast+ License

#ifndef __SFJP_ROAST_EX__graphics__directx__dx9__first_HPP__
#define __SFJP_ROAST_EX__graphics__directx__dx9__first_HPP__

#include "roast/graphics/directx/dx9/common.hpp"

namespace roast
{
	namespace directx
	{
		namespace dx9
		{
			namespace graphics
			{
				//////////////////////////////////////////////////////////////////////////////////////////////

				class d3dcaps_impl : public d3dcaps_impl_base
				{
				protected:
					D3DCAPS9 m_caps;
				public:
					d3dcaps_impl(){}
					d3dcaps_impl(const D3DCAPS9& from) : m_caps(from) {}
				};

				////////////
				
				class first : public first_base, public iunknown_<idirect3d>
				{
				public:
					enum exception_codes
					{
						exception_codes__head = exception_code_root::first,

						first__Direct3DCreate9_Failed,
						get_device_caps__GetDeviceCaps_Failed,
						get_current_display_mode__GetAdapterDisplayMode_Failed
					};
				public:
					first(){
						m_if = ::Direct3DCreate9( D3D_SDK_VERSION );
						if ( m_if == NULL )
							throw api_error(first__Direct3DCreate9_Failed, "Direct3DCreate9() Failed.");
					}

					////////////////////////////////////////////////////////

					d3dcaps get_device_caps(UINT AdapterNo, D3DDEVTYPE DeviceType)
					{
						D3DCAPS9 caps;
						if ( m_if->GetDeviceCaps( AdapterNo, DeviceType, &caps ) != D3D_OK )
							throw api_error(get_device_caps__GetDeviceCaps_Failed, ::std::string(
								"IDirect3D9::GetDeviceCaps(AdapterNo=")+_itostr(AdapterNo)+
								",DeviceType="+_itostr(DeviceType)+") Failed.");
						return d3dcaps(d3dcaps_impl(caps));
					}
					d3dcaps get_caps(UINT AdapterNo, D3DDEVTYPE DeviceType){ return get_device_caps(AdapterNo, DeviceType); }

					////

					disp_mode get_current_display_mode(UINT AdapterNo=0)
					{
						D3DDISPLAYMODE dispMode;
						assert_dxapi( get_current_display_mode__GetAdapterDisplayMode_Failed,
							m_if->GetAdapterDisplayMode(AdapterNo, &dispMode),
							::std::string("IDirect3D9::GetDeviceCaps(AdapterNo=")+_itostr(AdapterNo)+") Failed.");

						disp_mode dm;
						/*dm.Width = dispMode.Width);
						dm.Height = dispMode.Height);
						dm.RefreshRate = dispMode.RefreshRate);
						dm.Format = dispMode.Format);*/
						dm.set_width(dispMode.Width);
						dm.set_height(dispMode.Height);
						dm.set_refresh_rate(dispMode.RefreshRate);
						dm.set_format(dispMode.Format);
						
						return dm;
					}

					////////////////////////////////////////////////////////

					idirect3d* get_idirect3d_ptr(){ return get_internal_ptr(); }
				};
	
				//////////////////////////////////////////////////////////////////////////////////////////////
			}
		}
	}
}

#endif//__SFJP_ROAST_EX__graphics__directx__dx9__first_HPP__
