//	Roast+ License

#ifndef __SFJP_ROAST_EX__graphics__directx__dx9__device_HPP__
#define __SFJP_ROAST_EX__graphics__directx__dx9__device_HPP__

#include "roast/graphics/directx/dx9/first.hpp"
#include "roast/windows/window.hpp"

namespace roast
{
	namespace directx
	{
		namespace dx9
		{
			namespace graphics
			{
				///////////////////////////////////////////////////////////////////////////

				template <int _DeviceModeN>
				struct common_device_mode_2_d3d_device_type{ static const ::D3DDEVTYPE value = D3DDEVTYPE_HAL; };
				template <> struct common_device_mode_2_d3d_device_type<device_mode::values::hardware>{ static const ::D3DDEVTYPE value = D3DDEVTYPE_HAL; };
				template <> struct common_device_mode_2_d3d_device_type<device_mode::values::reference>{ static const ::D3DDEVTYPE value = D3DDEVTYPE_REF; };
				template <> struct common_device_mode_2_d3d_device_type<device_mode::values::no_rendering>{ static const ::D3DDEVTYPE value = D3DDEVTYPE_NULLREF; };
				template <> struct common_device_mode_2_d3d_device_type<device_mode::values::user_renderer>{ static const ::D3DDEVTYPE value = D3DDEVTYPE_SW; };

				///////
				
				class device : public device_base, protected iunknown_<idirect3d_device>
				{
				public:
					enum exception_codes
					{
						exception_codes__head = exception_code_root::device,

						start__IDirect3D9_CreateDevice__Failed,
						begin_scene__BeginScene_Failed,
						end_scene__EndScene_Failed,
						present__Present_Failed,
						clear__Clear_Failed
					};
				protected:
					first& m_first;
				public:
					device(first &f) : m_first(f){};

					///////////////

					template <int _DeviceModeN>
					void start(
						const ::roast::windows::window &w,
						bool fullscreen,
						int adapter_no,
						const device_mode::_<_DeviceModeN> &device_mode)
					{
						::D3DDEVTYPE d3d_device_type = common_device_mode_2_d3d_device_type<_DeviceModeN>::value;

						DWORD behavior_flags_vp = D3DCREATE_SOFTWARE_VERTEXPROCESSING;
						if ( d3d_device_type == D3DDEVTYPE_HAL )
							behavior_flags_vp = D3DCREATE_HARDWARE_VERTEXPROCESSING;
						DWORD behavior_flags = behavior_flags_vp;

						///////////////////////////////////////////////////////////

						//	Get current display mode
						disp_mode dispmode = m_first.get_current_display_mode(adapter_no);

						//	Present Parameters
						::D3DPRESENT_PARAMETERS pp;
						::ZeroMemory( &pp, sizeof(pp) );

						pp.BackBufferHeight = w.get_height();
						pp.BackBufferWidth = w.get_width();
						pp.BackBufferFormat = (D3DFORMAT)dispmode.get_format();
						pp.BackBufferCount = 1;

						pp.Windowed = (fullscreen ? FALSE : TRUE);
						pp.MultiSampleType = D3DMULTISAMPLE_NONE;
						pp.SwapEffect = D3DSWAPEFFECT_DISCARD;
						//pp.hDeviceWindow = hWnd;
						pp.FullScreen_RefreshRateInHz  = D3DPRESENT_RATE_DEFAULT;

						///////////////////////////////////////////////////////////

						//	IDirect3D::CreateDevice
						::HRESULT hr = m_first.get_idirect3d_ptr()->CreateDevice(
							adapter_no, d3d_device_type, w.get_hwnd(), behavior_flags, &pp, &m_if );
						
						if ( hr != D3D_OK ){
							//	Retry to Mixed Vertex Processing
							hr = m_first.get_idirect3d_ptr()->CreateDevice(adapter_no, d3d_device_type, w.get_hwnd(), behavior_flags | D3DCREATE_MIXED_VERTEXPROCESSING, &pp, &m_if );
							if ( hr != D3D_OK ){
								//	Retry to Software Vertex Processing
								hr = m_first.get_idirect3d_ptr()->CreateDevice(adapter_no, d3d_device_type, w.get_hwnd(), behavior_flags | D3DCREATE_SOFTWARE_VERTEXPROCESSING, &pp, &m_if );
								if ( hr != D3D_OK ){
									if ( _DeviceModeN == device_mode::values::_auto )
										start<>(w,fullscreen,adapter_no,device_mode::reference);
									else
										throw api_error(start__IDirect3D9_CreateDevice__Failed,
										"IDirect3D9::CreateDevice() Failed.", hr);
								}
							}
						}
					}

					void start(
						const ::roast::windows::window &w,
						bool fullscreen=false,
						int adapter_no=0)
					{
						start<>(w,fullscreen,adapter_no,device_mode::auto_);
					}
					
					//////////////////////////////////////////////////////////////////////////////
					
					void begin_scene()
					{
						//if ( m_if == NULL )
						//	throw exception("device::begin_scene()  not normally initialized.");

						::HRESULT hr = m_if->BeginScene();
						if ( hr != D3D_OK )
							throw api_error(begin_scene__BeginScene_Failed,"IDirect3DDevice9::BeginScene() Failed.", hr);
					}
					
					void end_scene()
					{
						::HRESULT hr = m_if->EndScene();
						if ( hr != D3D_OK )
							throw api_error(end_scene__EndScene_Failed,"IDirect3DDevice9::EndScene() Failed.", hr);
					}

					void present(const ::RECT *source_rect/*=NULL*/, const ::RECT *dest_rect=NULL, ::HWND dest_window_override=NULL, const ::RGNDATA* dirty_region=NULL)
					{
						::HRESULT hr = m_if->Present(source_rect, dest_rect, dest_window_override, dirty_region);
						if ( hr != D3D_OK )
							throw api_error(present__Present_Failed,"IDirect3DDevice9::Present() Failed.", hr);
					}
					void present(){ present(NULL); }
					//void present(){ present(::RECT(), ::RECT()); }
					//void present(const ::RECT &source_rect, const ::RECT &dest_rect){ present(source_rect, dest_rect, NULL, ::RGNDATA()); }
					/*void present(const ::RECT &source_rect, const ::RECT &dest_rect, ::HWND dest_window_override, const ::RGNDATA& dirty_region)
					{
						HRESULT hr = m_if->Present(&source_rect, &dest_rect, dest_window_override, &dirty_region);
						if ( hr != D3D_OK )
							throw api_error("IDirect3DDevice9::Present() Failed.", hr);
					}*/
					
					void clear(const color_t& cl=colordef::black)
					{
						clear(0,NULL,D3DCLEAR_TARGET,cl);
					}
					void clear(int rect_count, const ::RECT *rect_array, DWORD targets, D3DCOLOR color, float z=1.0, DWORD stencil=0)
					{
						::HRESULT hr = m_if->Clear(rect_count, (D3DRECT*)rect_array, targets, color, z, stencil);
						if ( hr != D3D_OK )
							throw api_error(clear__Clear_Failed,"IDirect3DDevice9::Clear() Failed.", hr);
					}
					
					//////////////////////////////////////////////////////////////////////////////
					
					idirect3d_device* get_idirect3d_device_ptr(){ return get_internal_ptr(); }
					idirect3d_device* get_id3d_device_ptr(){ return get_internal_ptr(); }
					idirect3d_device* get_id3ddevice_ptr(){ return get_internal_ptr(); }
					idirect3d_device* get_d3ddevice_ptr(){ return get_internal_ptr(); }
					idirect3d_device* get_id3ddev_ptr(){ return get_internal_ptr(); }
					idirect3d_device* get_d3ddev_ptr(){ return get_internal_ptr(); }

					const idirect3d_device* get_idirect3d_device_ptr() const { return get_internal_ptr(); }
					const idirect3d_device* get_id3d_device_ptr() const { return get_internal_ptr(); }
					const idirect3d_device* get_id3ddevice_ptr() const { return get_internal_ptr(); }
					const idirect3d_device* get_d3ddevice_ptr() const { return get_internal_ptr(); }
					const idirect3d_device* get_id3ddev_ptr() const { return get_internal_ptr(); }
					const idirect3d_device* get_d3ddev_ptr() const { return get_internal_ptr(); }
				};

				///////////////////////////////////////////////////////////////////////////
			}
		}
	}
}

#endif//__SFJP_ROAST_EX__graphics__directx__dx9__device_HPP__
