//	Roast+ License

#ifndef __SFJP_ROAST_EX__graphics__directx__dx9__buffer_HPP__
#define __SFJP_ROAST_EX__graphics__directx__dx9__buffer_HPP__

#include "roast/graphics/directx/dx9/device.hpp"
#include "roast/graphics/directx/shader_param.hpp"	//	Hmm...

namespace roast
{
	namespace directx
	{
		namespace dx9
		{
			namespace graphics
			{
				///////////////////////////////////////////////////////////////////////////

				class vertex_buffer : /*public buffer_base,*/ protected iunknown_<d3dvertexbuffer>
				{
				public:
					typedef d3dvertexbuffer _BufferT, _IfType;
					enum exception_codes
					{
						exception_codes__head = exception_code_root::buffer,

						buffer__CreateBuffer_Failed
					};
				protected:
					device& m_dev;

				public:
					vertex_buffer(device &d, DWORD fvf, unsigned int size, const void* initial_data=NULL,
						DWORD usage=0, D3DPOOL pool=D3DPOOL_DEFAULT) : m_dev(d)
					{
						//DX8:
						//	HRESULT hr = m_dev.get_id3d_device_ptr()->CreateVertexBuffer( size, usage, fvf, pool, &m_if);
						HRESULT hr = m_dev.get_id3d_device_ptr()->CreateVertexBuffer( size, usage, fvf, pool, &m_if, NULL);
						if ( hr != D3D_OK ){
							throw api_error(buffer__CreateBuffer_Failed,
								"ID3D9Device::CreateBuffer() Failed.", hr);
						}
					}

					///////////////

					
					//////////////////////////////////////////////////////////////////////////////
					
					_BufferT* get_buffer_ptr(){ return get_internal_ptr(); }
					const _BufferT* get_buffer_ptr() const { return get_internal_ptr(); }
				};

				///////////////////////////////////////////////////////////////////////////

				template <typename VERTEX_TYPE>
				class input_vertex_buffer : public vertex_buffer
				{
				public:
					input_vertex_buffer(device &d, const VERTEX_TYPE* initial_data, unsigned int size)
						: vertex_buffer(d,size,initial_data){}
				};

				///////////////////////////////////////////////////////////////////////////
			}
		}
	}
}

#endif//__SFJP_ROAST_EX__graphics__directx__dx9__buffer_HPP__
