//	Roast+ License

#ifndef __SFJP_ROAST_EX__graphics__directx__dx10__device_HPP__
#define __SFJP_ROAST_EX__graphics__directx__dx10__device_HPP__

#include "roast/graphics/directx/dx10/first.hpp"

namespace roast
{
	namespace directx
	{
		namespace dx10
		{
			namespace graphics
			{
				///////////////////////////////////////////////////////////////////////////
				
				template <int _DeviceModeN>
				struct common_device_mode_2_d3d_device_type{ static const ::D3D10_DRIVER_TYPE value = D3D10_DRIVER_TYPE_HARDWARE; };
				template <> struct common_device_mode_2_d3d_device_type<device_mode::values::hardware>{ static const ::D3D10_DRIVER_TYPE value = D3D10_DRIVER_TYPE_HARDWARE; };
				template <> struct common_device_mode_2_d3d_device_type<device_mode::values::reference>{ static const ::D3D10_DRIVER_TYPE value = D3D10_DRIVER_TYPE_REFERENCE; };
				template <> struct common_device_mode_2_d3d_device_type<device_mode::values::no_rendering>{ static const ::D3D10_DRIVER_TYPE value = D3D10_DRIVER_TYPE_NULL; };
				template <> struct common_device_mode_2_d3d_device_type<device_mode::values::user_renderer>{ static const ::D3D10_DRIVER_TYPE value = D3D10_DRIVER_TYPE_SOFTWARE; };

				///////

				class device : public device_base, protected iunknown_<idirect3d_device>
				{
				public:
					enum exception_codes
					{
						exception_codes__head = exception_code_root::device,

						start__D3D10CreateDeviceAndSwapChain__Failed,
						start__CreateRenderTargetView__Failed,
						begin_scene__BeginScene_Failed,
						end_scene__EndScene_Failed,
						present__Present_Failed,
						clear__ClearRenderTargetView_Failed
					};
				protected:
					first& m_first;

					iunknown_<::IDXGISwapChain> m_swapchain;
					iunknown_<::ID3D10Texture2D> m_backbuf;
					iunknown_<::ID3D10RenderTargetView> m_view;

				public:
					device(first &f) : m_first(f){};

					///////////////

					template <int _DeviceModeN>
					void start(
						const ::roast::windows::window &w,
						bool fullscreen,
						int adapter_no,
						const device_mode::_<_DeviceModeN> &device_mode)
					{
						::D3D10_DRIVER_TYPE d3d_driver_type = common_device_mode_2_d3d_device_type<_DeviceModeN>::value;

						///////////////////////////////////////////////////////////

						::DXGI_SWAP_CHAIN_DESC scdesc;
						::ZeroMemory( &scdesc, sizeof(scdesc) );
						scdesc.BufferCount = 1;
						scdesc.BufferDesc.Width = w.get_height();
						scdesc.BufferDesc.Height = w.get_width();
						scdesc.BufferDesc.Format = DXGI_FORMAT_R8G8B8A8_UNORM;
						scdesc.BufferDesc.RefreshRate.Numerator = 60;
						scdesc.BufferDesc.RefreshRate.Denominator = 1;
						scdesc.BufferUsage = DXGI_USAGE_RENDER_TARGET_OUTPUT;
						scdesc.OutputWindow = w.get_hwnd();
						scdesc.SampleDesc.Count = 1;
						scdesc.SampleDesc.Quality = 0;
						scdesc.Windowed = (fullscreen ? FALSE : TRUE);

						///////////////////////////////////////////////////////////

						//	Create Device
						::HRESULT hr = ::D3D10CreateDeviceAndSwapChain( NULL, d3d_driver_type, NULL,
										0, D3D10_SDK_VERSION, &scdesc, m_swapchain.get_ptrptr(), &m_if );
						if ( hr != D3D_OK ){
							throw api_error(start__D3D10CreateDeviceAndSwapChain__Failed,
								"D3D10CreateDeviceAndSwapChain() Failed.", hr);
						}

						//	GetBuffer
						m_swapchain->GetBuffer( 0, __uuidof(::ID3D10Texture2D), (void**)m_backbuf.get_ptrptr() );

						//	CreateRenderTargetView
						hr = m_if->CreateRenderTargetView( m_backbuf, NULL, m_view.get_ptrptr() );
						if ( hr != D3D_OK ){
							throw api_error(start__CreateRenderTargetView__Failed,
								"ID3D10Device::CreateRenderTargetView() Failed.", hr);
						}
						m_backbuf->Release();

						//	OMSetRenderTargets
						m_if->OMSetRenderTargets( 1, m_view.get_ptrptr(), NULL );
						
						//	RSSetViewports
						::D3D10_VIEWPORT vp;
						vp.Width = scdesc.BufferDesc.Width;
						vp.Height = scdesc.BufferDesc.Height;
						vp.MinDepth = 0.0f;
						vp.MaxDepth = 1.0f;
						vp.TopLeftX = 0;
						vp.TopLeftY = 0;
						m_if->RSSetViewports( 1, &vp );
					}

					void start(
						const ::roast::windows::window &w,
						bool fullscreen=false,
						int adapter_no=0)
					{
						start<>(w,fullscreen,adapter_no,device_mode::auto_);
					}
					
					//////////////////////////////////////////////////////////////////////////////
					
					void begin_scene()
					{
					}
					
					void end_scene()
					{
					}

					void present()
					{
						::HRESULT hr = m_swapchain->Present(0,0);
						if ( hr != D3D_OK )
							throw api_error(present__Present_Failed,"IDXGISwapChain::Present() Failed.", hr);
					}
					
					void clear(const color_t& cl=colordef::black)
					{
						/*float clear_values[4] = {
							ROAST_HEXCOLOR_GETR(cl) / 255.0f,
							ROAST_HEXCOLOR_GETG(cl) / 255.0f,
							ROAST_HEXCOLOR_GETB(cl) / 255.0f,
							ROAST_HEXCOLOR_GETA(cl) / 255.0f
						};*/

						/*::HRESULT hr = */m_if->ClearRenderTargetView(m_view, d3dcolor_2_float4(cl).values/*clear_values*/);
						//if ( hr != D3D_OK )
						//	throw api_error(clear__ClearRenderTargetView_Failed,"ID3D10Device::ClearRenderTargetView() Failed.", hr);
					}
					
					//////////////////////////////////////////////////////////////////////////////
					
					idirect3d_device* get_idirect3d_device_ptr(){ return get_internal_ptr(); }
					idirect3d_device* get_id3d_device_ptr(){ return get_internal_ptr(); }
					idirect3d_device* get_id3ddevice_ptr(){ return get_internal_ptr(); }
					idirect3d_device* get_d3ddevice_ptr(){ return get_internal_ptr(); }
					idirect3d_device* get_id3ddev_ptr(){ return get_internal_ptr(); }
					idirect3d_device* get_d3ddev_ptr(){ return get_internal_ptr(); }

					const idirect3d_device* get_idirect3d_device_ptr() const { return get_internal_ptr(); }
					const idirect3d_device* get_id3d_device_ptr() const { return get_internal_ptr(); }
					const idirect3d_device* get_id3ddevice_ptr() const { return get_internal_ptr(); }
					const idirect3d_device* get_d3ddevice_ptr() const { return get_internal_ptr(); }
					const idirect3d_device* get_id3ddev_ptr() const { return get_internal_ptr(); }
					const idirect3d_device* get_d3ddev_ptr() const { return get_internal_ptr(); }
				};

				///////////////////////////////////////////////////////////////////////////
			}
		}
	}
}

#endif//__SFJP_ROAST_EX__graphics__directx__dx10__device_HPP__
