//	Roast+ License

#ifndef __SFJP_ROAST_EX__graphics__directx__common_HPP__
#define __SFJP_ROAST_EX__graphics__directx__common_HPP__

#include <windows.h>
#include <string>

namespace roast
{
	namespace directx
	{
		inline ::std::string _ito08X_str(unsigned long u)
		{
			char work[16];
#pragma warning( disable : 4996 )
			sprintf(work, "%08X", u);
#pragma warning( default : 4996 )
			return work;
		}
		inline ::std::string _itostr(int n)
		{
			char work[16];
#pragma warning( disable : 4996 )
			sprintf(work, "%d", n);
#pragma warning( default : 4996 )
			return work;
		}

		class exception : public ::std::string
		{
		protected:
			unsigned long m_no;
		public:
			exception(unsigned long no, const ::std::string &s) : m_no(no), ::std::string(s) {}
			exception(unsigned long no, const char* msg) : m_no(no), ::std::string(msg) {}
		};
		
		class api_exception : public exception
		{
		public:
			api_exception(unsigned long no, const char* msg) : exception(no,msg){}
			api_exception(unsigned long no, const char* msg, unsigned long api_error_code) :
			  exception(no, ::std::string(msg) + "  API Error Code: 0x" + _ito08X_str(api_error_code)){}
			api_exception(unsigned long no, const ::std::string &s) : exception(no,s){}
			api_exception(unsigned long no, const ::std::string &s, unsigned long api_error_code) :
			  exception(no, s + "  API Error Code: 0x" + _ito08X_str(api_error_code)){}
		};
		typedef api_exception api_error;

		////

		inline void assert_api(unsigned long no, unsigned int api_ret, unsigned int success, const char* msg)
		{
			if ( api_ret != success )
				throw api_exception(no, msg, api_ret);
		}
		inline void assert_api(unsigned long no, unsigned int api_ret, unsigned int success, const ::std::string &msg)
		{
			if ( api_ret != success )
				throw api_exception(no, msg, api_ret);
		}
		inline void assert_dxapi(unsigned long no, unsigned int api_ret, const char* msg)
		{
			if ( api_ret != D3D_OK )
				throw api_exception(no, msg, api_ret);
		}
		inline void assert_dxapi(unsigned long no, unsigned int api_ret, const ::std::string &msg)
		{
			if ( api_ret != D3D_OK )
				throw api_exception(no, msg, api_ret);
		}
		
		///////////////////////////////////////////////////////////////////////////////////////
		
		template <typename T>
		class iunknown_
		{
		protected:
			T* m_if;
		public:
			iunknown_(){
				m_if = NULL;
			}
			iunknown_(const iunknown_<T> &from){
				m_if = from.m_if;
				if ( m_if != NULL )
					m_if->AddRef();
			}
			virtual ~iunknown_(){ release(); }
			
			////////////////////////////////////////////////

			void release(){
				if ( m_if ){
					m_if->Release();
					m_if = NULL;
				}
			}

			T* get_internal_interface(){ return m_if; }
			T* get_internal_if_ptr(){ return m_if; }
			T* get_internal_ptr(){ return m_if; }
			T** get_ptrptr(){ return &m_if; }

			const T* get_internal_interface() const { return m_if; }
			const T* get_internal_if_ptr() const { return m_if; }
			const T* get_internal_ptr() const { return m_if; }
			const T** get_ptrptr() const { return &m_if; }

			T* operator ->() { return m_if; }
			const T* operator ->() const { return m_if; }
			operator T*() { return m_if; }
			operator const T*() const { return m_if; }
		};
		
		namespace graphics
		{
			///////////////////////////////////////////////////////////////////////////////////////
			
			//	Device Modes (HAL/REF/...)
			namespace device_mode
			{
				namespace values
				{
					enum _
					{
						hardware=0,
						reference=1,
						no_rendering=2,
						user_renderer=3,
						_auto=99
					};
				}
				
				template <int N>
				class _{ public: static const int value = N; };
				
				/*typedef _<values::hardware> hardware;
				typedef _<values::reference> software;
				typedef _<values::reference> reference;
				typedef _<values::user_renderer> user_renderer;
				typedef _<values::no_rendering> no_rendering;
				typedef _<values::_auto> _auto;
				typedef _<values::_auto> auto_;*/
				static const _<values::hardware> hardware;
				static const _<values::reference> software;
				static const _<values::reference> reference;
				static const _<values::user_renderer> user_renderer;
				static const _<values::no_rendering> no_rendering;
				static const _<values::_auto> _auto;
				static const _<values::_auto> auto_;
			}

			//template <int N>
			//class device_mode_ : public device_mode::_<N> {};

			//////////////////////////////////////////////////////////

			//	T&L(Transform and Lighting) Modes
			namespace tnl_mode
			{
				namespace values
				{
					enum _
					{
						hardware=0,
						software=1,
						mixed=2
					};
				}
				
				template <int N>
				class _{ public: static const int value = N; };
				
				static const _<values::hardware> hardware;
				static const _<values::software> software;
				static const _<values::mixed> mixed;
			}

			template <int N>
			class tnl_mode_ : public tnl_mode::_<N> {};

			//////////////////////////////////////////////////////////

			namespace shader_model_type
			{
				enum _
				{
					fx,
					vs,
					ps,
					cs,
					ds,
					hs,
					gs
				};

				//char to_uchar1
				template <::roast::directx::graphics::shader_model_type::_ TYPE>
				struct to_char{};

				template<> struct to_char<fx>{ const static unsigned char value1='f'; const static unsigned char value2='x'; };
				template<> struct to_char<vs>{ const static unsigned char value1='v'; const static unsigned char value2='s'; };
				template<> struct to_char<ps>{ const static unsigned char value1='p'; const static unsigned char value2='s'; };
				template<> struct to_char<cs>{ const static unsigned char value1='c'; const static unsigned char value2='s'; };
				template<> struct to_char<ds>{ const static unsigned char value1='d'; const static unsigned char value2='s'; };
				template<> struct to_char<hs>{ const static unsigned char value1='h'; const static unsigned char value2='s'; };
				template<> struct to_char<gs>{ const static unsigned char value1='g'; const static unsigned char value2='s'; };
			}
			typedef shader_model_type::_ shader_model_type_e;

			template <shader_model_type_e TYPE, unsigned char MAJOR, unsigned char MINOR=0>
			struct shader_model
			{
				static const shader_model_type_e type = TYPE;
				static const unsigned char major = MAJOR;
				static const unsigned char minor = MINOR;

				shader_model()
				{
					_buf[0] =
						(unsigned long)shader_model_type::to_char<TYPE>::value1 |
						(unsigned long)shader_model_type::to_char<TYPE>::value2 << 8 |
						(unsigned long)'_' << 16 |
						((unsigned long)'0' + (MAJOR%10)) << 24;
					_buf[1] =
						(unsigned int)'_' |
						((unsigned int)'0' + (MINOR%10)) << 8;
				}
				/*const char* to_string(){
					if ( _initialized
				}*/
				const char* to_string() const { return (const char*)_buf; }
			private:
				//static const bool _initialized = false;
				//mutable char _buf[8]; 
				unsigned long _buf[2];
			};
		}
		//////////////////////////////////////////////////////////
	}
}

#include "roast/graphics/directx/color.hpp"
#include "roast/graphics/directx/bases.hpp"

#endif//__SFJP_ROAST_EX__graphics__directx__common_HPP__
