//	Roast+ License

//	SIMD

#ifndef __SFJP_OPENMGL_roast__simd__sse2_ibase_HPP__
#define __SFJP_OPENMGL_roast__simd__sse2_ibase_HPP__

#include "simd_common.hpp"
#include <emmintrin.h>	/*	intrinsic functions for SSE2	*/

#define _ROAST_SIMD_SSE2_I_REG_T			__m128i
#define _ROAST_SIMD_SSE2_I_PARAM_REG_T	__m128i

namespace roast
{
	namespace simd 
	{
		/*=========================================================*/

		/*  SSE2: any integer base  */
		class _sse2_i
		{
		public:
			typedef _ROAST_SIMD_SSE2_I_REG_T _REG_T;
			
			typedef _ROAST_SIMD_SSE2_I_PARAM_REG_T _REG_PARAM;
			typedef _ROAST_SIMD_SSE2_I_REG_T _REG_RET;
			typedef _ROAST_SIMD_SSE2_I_PARAM_REG_T _M_PARAM;
			typedef _ROAST_SIMD_SSE2_I_REG_T _M_RET;
		public:
			_REG_RET zerofill(){ return _mm_setzero_si128(); }
			
			/*-------------------------------------------------------------*/
			
			/*	bit operations	*/
			_REG_RET and(_REG_PARAM m1, _REG_PARAM m2){ return _mm_and_si128(m1,m2); }
			_REG_RET or(_REG_PARAM m1, _REG_PARAM m2){ return _mm_or_si128(m1,m2); }
			_REG_RET xor(_REG_PARAM m1, _REG_PARAM m2){ return _mm_xor_si128(m1,m2); }
			_REG_RET andnot(_REG_PARAM m1, _REG_PARAM m2){ return _mm_andnot_si128(m1,m2); }
			
			/*	shift operations	*/
			_REG_RET lshift(_REG_PARAM m1, int shift_count){ return _mm_slli_si128(m1,shift_count); }
			_REG_RET rshift(_REG_PARAM m1, int shift_count){ return _mm_srli_si128(m1,shift_count); }
			
			/*-------------------------------------------------------------*/

			/*	mask operations	*/
			int m2mask(_M_PARAM m){ return _mm_movemask_epi8(m); }
			bool mask2bool(_REG_PARAM m){ return ( m2mask(m) == 0xffff ) ? true : false; }
			
			/*	compare equal?	*/
			_REG_RET _cmpeq_epi8(_REG_PARAM m1, _REG_PARAM m2){ return _mm_cmpeq_epi8(m1,m2); }
			bool is_all_equal(_REG_PARAM m1, _REG_PARAM m2){ return mask2bool(_cmpeq_epi8(m1, m2)); }

			/*-------------------------------------------------------------*/
		};
	}
}

#endif//__SFJP_OPENMGL_roast__simd__sse2_ibase_HPP__
