<?php
/**
 * サイト状態確認画面クラス
 *
 * サイト状態確認画面を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "admin_site_base.inc" );

  class sitestat_confirm extends admin_site_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが「admin.stat」でない or 前画面のActが「sitestat_select」でない場合、
      // 入力画面に飛ばす
      $tmp_cage = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != 'admin.site' or ( $tmp_act != 'sitestat_select' ) )
      {
        $this->obj_util->redirectTo( 'sitestat_select', 'admin.site' );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'change' ] = null;

      // ユーザ名
      if ( isset( $_POST[ 'status' ] ) )
      {
        $tmp_entered[ 'change' ] = strip_tags( trim( $_POST[ 'status' ] ) );
      } // end of if



      //------------------------------------------------------//
      // 入力値のチェック
      //------------------------------------------------------//
      // ステータス
      if ( ! is_numeric( $tmp_entered[ 'change' ] ) )
      {
        // 例外を投げる（ありえないので）
        throw new Exception( 'Cannot happend!' );
        return false;
      } // end of if



      //------------------------------------------------------//
      // 表示情報の取得
      //------------------------------------------------------//
      $this->gotDat[ 'current' ] = $this->statuslist[ $this->obj_util->serviceStatus() ];
      $this->gotDat[ 'change'  ] = $this->statuslist[ $tmp_entered[ 'change' ]         ];



      //------------------------------------------------------//
      // セッションに値を格納（次画面で使用するため）
      //------------------------------------------------------//
      $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered[ 'change' ] );

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',  $this->obj_util->getHeader() );

      $this->smarty->assign ( 'current', $this->gotDat[ 'current' ] );
      $this->smarty->assign ( 'change',  $this->gotDat[ 'change'  ] );

      // 表示
      $this->smarty->display( 'sitestat_confirm.tpl' );

      return true;

    } // end of function:view()

  } // end of class:sitestat_confirm
?>
