<?php
/**
 * 新規ページ追加確認画面クラス
 *
 * 新規ページ追加確認画面を実現するためのクラス
 *
 * @package   simplepage
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simplepage_base.inc" );

  class pageadd_confirm extends simplepage_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'simplepage.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが自分と同じでない or 前画面のActが「pageadd_entry」でない場合、
      // 入力画面に飛ばす
      $tmp_cage_last    = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage'    ) );
      $tmp_cage_current = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact' );

      if ( ( $tmp_cage_last != $tmp_cage_current ) or ( $tmp_act != 'pageadd_entry' ) )
      {
        $this->obj_util->redirectTo( 'pageadd_entry', $tmp_cage_current );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'title' ] = null;
      $tmp_entered[ 'body'  ] = null;

      // タイトル
      if ( isset( $_POST[ 'title' ] ) )
      {
        $tmp_entered[ 'title' ] = strip_tags( trim( $_POST[ 'title' ] ) );
      } // end of if
      // 本文
      if ( isset( $_POST[ 'body' ] ) )
      {
        $tmp_entered[ 'body'  ] = strip_tags( trim( $_POST[ 'body'  ] ), $this->obj_conf->get( 'ALLOWTAGS', 'body' ) );
        $tmp_entered[ 'body'  ] = str_replace( array( "\r\n", "\n", "\r" ), "", $tmp_entered[ 'body' ] );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // タイトル（入力値が空）
      if ( empty( $tmp_entered[ 'title' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'empty_title';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'pageadd_entry', $tmp_cage_current );
        return false;
      } // end of if

      // タイトル（入力値が半角255文字以上）
      if ( strlen( $tmp_entered[ 'title' ] ) > 255 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'toolong_title';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'pageadd_entry', $tmp_cage_current );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // 特に問題がなければ、画面表示用にクラス変数とセッションに値をセットする
      //------------------------------------------------------------------------
      $this->gotDat = $tmp_entered;
      $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentact' ), $tmp_entered );

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',            $this->obj_util->getHeader() );

      $this->smarty->assign ( 'entered_title',     $this->gotDat[ 'title'  ] );
      $this->smarty->assign ( 'entered_body',      $this->gotDat[ 'body'   ] );

      $this->smarty->assign ( 'mycage',            str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) ) );

      // 表示
      $this->smarty->display( 'pageadd_confirm.tpl' );

      return true;

    } // end of function:view()

  } // end of class:pageadd_confirm

?>
