{include file='../common/admin_header.tpl'}
<h1>新規ブログ記事追加(入力)</h1>
<form method="POST" action="?cage={$mycage}&amp;act=blogadd_confirm">
 {if      $errMsg == 'empty_title'}
 <p class="warning">
    >>> タイトルが入力されていません。
 </p>
 {elseif  $errMsg == 'toolong_title'}
 <p class="warning">
    >>> タイトルが長すぎます。半角255文字以内にしてください。
 </p>
 {elseif  $errMsg == 'empty_body'}
 <p class="warning">
    >>> 本文が入力されていません。
 </p>
 {elseif  $errMsg == 'invalid_postdate'}
 <p class="warning">
    >>> 投稿日が不正です。
 </p>
 {elseif  $errMsg == 'invalid_opendate'}
 <p class="warning">
    >>> 公開開始日が不正です。
 </p>
 {elseif  $errMsg == 'invalid_enddate'}
 <p class="warning">
    >>> 公開終了日が不正です。
 </p>
 {/if}
 <p>
  下記に追加するブログ記事の情報を入力してください。「タイトル」、「本文」、「投稿日」、「公開開始日」は必須項目となります。
 </p>
{if $is_fckeditor}
 <table width="80%">
{else}
 <table>
{/if}
  <tr>
   <th>ブログタイトル</th>
   <td><input name="title" type="input" value="{$entered_title}"  maxlength="255" size="80" /></td>
  </tr>
  <tr>
   <th>ブログ本文</th>
{if $is_fckeditor}
{literal}
   <td>
   <script type="text/javascript">
     var oFCKeditor = new FCKeditor('body');
     oFCKeditor.Config[ "CustomConfigurationsPath" ] = {/literal}'{$base_url}/js/simpleblog_fckeditor_config.js?' + ( new Date() * 1 ){literal};
     oFCKeditor.ToolbarSet = 'simpleblog';
     oFCKeditor.BasePath = {/literal}"{$base_url}/fckeditor/"{literal};
     oFCKeditor.Value  = {/literal}'{$entered_body|escape:'quotes'|replace:"\n":""|replace:"\r":""}'{literal};
     oFCKeditor.Create();
   </script>
   </td>
{/literal}
{else}
   <td><textarea name="body" cols="50" rows="10">{$entered_body}</textarea></td>
{/if}
  </tr>
  <tr>
    <th>投稿日<br>（表示上の日付）</th>
    <td>
      {html_options name=posted_year   options=$arrPostedYear selected=$entered_postyear}年&nbsp;
      {html_options name=posted_month  options=$arrMonth      selected=$entered_postmonth}月&nbsp;
      {html_options name=posted_day    options=$arrDay        selected=$entered_postday}日&nbsp;
      {html_options name=posted_hour   options=$arrHour       selected=$entered_posthour}時&nbsp;
      {html_options name=posted_minite options=$arrMinSec     selected=$entered_postminite}分&nbsp;
      {html_options name=posted_second options=$arrMinSec     selected=$entered_postsecond}秒
    </td>
  </tr>
  <tr>
    <th>公開開始日</th>
    <td>
      {html_options name=open_year   options=$arrOpenYear selected=$entered_openyear}年&nbsp;
      {html_options name=open_month  options=$arrMonth    selected=$entered_openmonth}月&nbsp;
      {html_options name=open_day    options=$arrDay      selected=$entered_openday}日&nbsp;
      {html_options name=open_hour   options=$arrHour     selected=$entered_openhour}時&nbsp;
      {html_options name=open_minite options=$arrMinSec   selected=$entered_openminite}分&nbsp;
      {html_options name=open_second options=$arrMinSec   selected=$entered_opensecond}秒
    </td>
  </tr>
  <tr>
    <th>公開終了日</th>
    <td>
      {html_options name=end_year   options=$arrEndYear    selected=$entered_endyear}年&nbsp;
      {html_options name=end_month  options=$arrMonth_end  selected=$entered_endmonth}月&nbsp;
      {html_options name=end_day    options=$arrDay_end    selected=$entered_endday}日&nbsp;
      {html_options name=end_hour   options=$arrHour_end   selected=$entered_endhour}時&nbsp;
      {html_options name=end_minite options=$arrMinSec_end selected=$entered_endminite}分&nbsp;
      {html_options name=end_second options=$arrMinSec_end selected=$entered_endsecond}秒
    </td>
  </tr>
 </table>
 <input type="button" value="一覧に戻る" onClick="location.href='?cage={$mycage}&amp;act=bloglist'"/>
 <input type="submit" value="入力内容の確認" />
 <input type="reset"  value="入力内容をリセットする" />
</form>
{include file='../common/admin_footer.tpl'}
