<?php
/**
 * インストール画面(7)クラス
 *
 * インストール画面(7)を実現するためのクラス
 *
 * @package   risoluto
 * @author    Yuta Hayakawa <haya@hyec.org>
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Yuta Hayakawa / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'install_base.inc' );

  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class page06 extends install_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * パスワード登録状況格納用変数
     * @access private
     * @var    string
     */
    private $regist;
    /**
     * エラーメッセージ格納用変数
     * @access private
     * @var    string
     */
    private $errMsg;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 前画面のCageが「install」でない or 前画面のActが「page05」 and 「page06」でない場合、
      // インストーラトップに飛ばす
      $tmp_cage = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != 'install' or ( $tmp_act != 'page05' and $tmp_act != 'page06' ) )
      {
        $this->obj_util->redirectTo( 'install', 'install' );
        return false;
      } // end of if

      // 前画面のCageが「install」 and 前画面のActが「page05」の場合、初期表示を行う
      if ( $tmp_cage == 'install' and $tmp_act == 'page05' )
      {
        $this->regist = 'NG';
        $this->errMsg = null;
        return true;
      } // end of if

      // $_POST[ 'password' ]または$_POST[ 'password_retype' ]が渡されてきていれば、
      // 以降の処理で使うために必要な処理を行う
      $tmp_passwd          = null;
      $tmp_passwd_retype   = null;
      if ( isset( $_POST[ 'password' ] ) )
      {
        $tmp_passwd        = trim( $_POST[ 'password'        ] );
      } // end of if
      if ( isset( $_POST[ 'password_retype' ] ) )
      {
        $tmp_passwd_retype = trim( $_POST[ 'password_retype' ] );
      } // end of if

      // $_POST[ 'password' ]または$_POST[ 'password_retype' ]が渡されてこなかった場合、初期表示を行う
      if ( empty( $tmp_passwd ) or empty( $tmp_passwd_retype ) )
      {
        $this->regist = 'NG';
        $this->errMsg = 'empty';
        return false;
      } // end of if

      // $_POST[ 'password' ]と$_POST[ 'password_retype' ]が一致しなかった場合、初期表示を行う
      if ( $tmp_passwd != $tmp_passwd_retype )
      {
        $this->regist = 'NG';
        $this->errMsg = 'notmatch';
        return false;
      } // end of if

      // データベース操作クラスのインスタンスを生成する
      $this->obj_db = new RisoluteDb();

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // トランザクションを開始
        $this->obj_db->dbBeginTransaction();

        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              UPDATE `risoluto_t_user`
                 SET `mtime`    = now()
                   , `muser`    = 'installer'
                   , `password` = ?
               WHERE `user_id`  = 0
                 AND `group_id` = 0

End_Of_SQL;

        // パラメタも用意する
        $param = array( sha1( $tmp_passwd ) );

        // SQLの実行に失敗したら初期表示とする
        if ( PEAR::isError( $this->obj_db->dbExecSQL( $sql, $param ) ) )
        {
          // エラーの場合はロールバックしてコネクションを閉じ、例外を投げる
          $this->obj_db->dbRollback();
          $this->obj_db->dbDisConnect();
          throw new Exception( 'UPDATE Failure' );
          return false;
        } // end of if
        else
        {
          // 正常に実行できた場合は、コミットしてコネクションを閉じる
          $this->obj_db->dbCommit();
          $this->obj_db->dbDisConnect();
        } // end of else

      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else

      // ここまでたどり着いたら、正常に更新できたことを意味します
      $this->regist = 'OK';
      $this->errMsg = null;
      return true;

    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'css'    ] = array( './css/common.css' );
      $html_header[ 'title'  ] = 'インストーラ(7)';

      // アサイン
      $this->smarty->assign ( 'header',    $html_header  );
      $this->smarty->assign ( 'regist',    $this->regist );
      $this->smarty->assign ( 'errMsg',    $this->errMsg );

      // 表示
      $this->smarty->display( 'page06.tpl' );

      return true;

    } // end of function:view()

  } // end of class:page06
?>
