<?php
/**
 * コントローラ起動ルーチン
 *
 * コントローラのクラスインスタンスを作成し、実行する
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Risoluto Developers / All Rights Reserved.
 */

  //------------------------------------------------------//
  // 定数定義
  //------------------------------------------------------//
  define( 'RISOLUTODIR',       dirname( dirname ( __FILE__ ) )     );
  define( 'RISOLUTO_DOCROOT',  dirname ( __FILE__ )                );
  define( 'RISOLUTO_SYSROOT',  RISOLUTODIR . '/risoluto/'          );
  define( 'RISOLUTO_BATCH',    RISOLUTODIR . '/risoluto/batch/'    );
  define( 'RISOLUTO_CACHE',    RISOLUTODIR . '/risoluto/cache/'    );
  define( 'RISOLUTO_CONF',     RISOLUTODIR . '/risoluto/conf/'     );
  define( 'RISOLUTO_EXTLIB',   RISOLUTODIR . '/risoluto/extlib/'   );
  define( 'RISOLUTO_FUNC',     RISOLUTODIR . '/risoluto/func/'     );
  define( 'RISOLUTO_LOGS',     RISOLUTODIR . '/risoluto/logs/'     );
  define( 'RISOLUTO_SESS',     RISOLUTODIR . '/risoluto/sess/'     );
  define( 'RISOLUTO_UPLOAD',   RISOLUTODIR . '/risoluto/upload/'   );
  define( 'RISOLUTO_USERLAND', RISOLUTODIR . '/risoluto/userland/' );

  //------------------------------------------------------//
  // インクルードパスの変更
  //------------------------------------------------------//
  set_include_path(                 RISOLUTO_EXTLIB . 'PEAR' 
                 . PATH_SEPARATOR . RISOLUTO_EXTLIB . 'Smarty/libs'
                 . PATH_SEPARATOR . get_include_path() );

  //------------------------------------------------------//
  // コントローラクラスの読み込み
  //------------------------------------------------------//
  require_once( RISOLUTO_FUNC . 'risoluto_core.php' );

  //------------------------------------------------------//
  // コントローラクラスインスタンスの生成と実行
  //------------------------------------------------------//
  $risoluto_instance = RisolutoCore::singleton();
  $risoluto_instance->run();
?>
